/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.search;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.SearchResponse;

public class SearchRequest {
    private static final TypeReference<SearchResponse> RESPONSE_TYPE = new TypeReference<SearchResponse>(){};
    private final ApiClient apiClient;
    private final Request request;

    public SearchRequest(ApiClient apiClient, String q, String type) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/search").addQueryParameter("q", String.valueOf(q)).addQueryParameter("type", String.valueOf(type));
    }

    public SearchRequest market(String market) {
        this.request.addQueryParameter("market", String.valueOf(market));
        return this;
    }

    public SearchRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public SearchRequest offset(int offset) {
        this.request.addQueryParameter("offset", String.valueOf(offset));
        return this;
    }

    public SearchRequest includeExternal(String includeExternal) {
        this.request.addQueryParameter("include_external", String.valueOf(includeExternal));
        return this;
    }

    public ApiCall<SearchResponse> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

