/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.playlists;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.Paging;
import de.sonallux.spotify.api.models.SimplifiedPlaylist;

public class GetListUsersPlaylistsRequest {
    private static final TypeReference<Paging<SimplifiedPlaylist>> RESPONSE_TYPE = new TypeReference<Paging<SimplifiedPlaylist>>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetListUsersPlaylistsRequest(ApiClient apiClient, String userId) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/users/{user_id}/playlists").addPathParameter("user_id", String.valueOf(userId));
    }

    public GetListUsersPlaylistsRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public GetListUsersPlaylistsRequest offset(int offset) {
        this.request.addQueryParameter("offset", String.valueOf(offset));
        return this;
    }

    public ApiCall<Paging<SimplifiedPlaylist>> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

