/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.player;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.CursorPaging;
import de.sonallux.spotify.api.models.PlayHistory;

public class GetRecentlyPlayedRequest {
    private static final TypeReference<CursorPaging<PlayHistory>> RESPONSE_TYPE = new TypeReference<CursorPaging<PlayHistory>>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetRecentlyPlayedRequest(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/me/player/recently-played");
    }

    public GetRecentlyPlayedRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public GetRecentlyPlayedRequest after(int after) {
        this.request.addQueryParameter("after", String.valueOf(after));
        return this;
    }

    public GetRecentlyPlayedRequest before(int before) {
        this.request.addQueryParameter("before", String.valueOf(before));
        return this;
    }

    public ApiCall<CursorPaging<PlayHistory>> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

