/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.player;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.CurrentlyPlayingContext;

public class GetInformationAboutUsersCurrentPlaybackRequest {
    private static final TypeReference<CurrentlyPlayingContext> RESPONSE_TYPE = new TypeReference<CurrentlyPlayingContext>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetInformationAboutUsersCurrentPlaybackRequest(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/me/player");
        this.additionalTypes("track,episode");
    }

    public GetInformationAboutUsersCurrentPlaybackRequest market(String market) {
        this.request.addQueryParameter("market", String.valueOf(market));
        return this;
    }

    public GetInformationAboutUsersCurrentPlaybackRequest additionalTypes(String additionalTypes) {
        this.request.addQueryParameter("additional_types", String.valueOf(additionalTypes));
        return this;
    }

    public ApiCall<CurrentlyPlayingContext> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

