/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.personalization;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.Paging;
import de.sonallux.spotify.api.models.Track;

public class GetUsersTopTracksRequest {
    private static final TypeReference<Paging<Track>> RESPONSE_TYPE = new TypeReference<Paging<Track>>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetUsersTopTracksRequest(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/me/top/tracks");
    }

    public GetUsersTopTracksRequest timeRange(String timeRange) {
        this.request.addQueryParameter("time_range", String.valueOf(timeRange));
        return this;
    }

    public GetUsersTopTracksRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public GetUsersTopTracksRequest offset(int offset) {
        this.request.addQueryParameter("offset", String.valueOf(offset));
        return this;
    }

    public ApiCall<Paging<Track>> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

