/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.browse;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.Recommendations;

public class GetRecommendationsRequest {
    private static final TypeReference<Recommendations> RESPONSE_TYPE = new TypeReference<Recommendations>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetRecommendationsRequest(ApiClient apiClient, String seedArtists, String seedGenres, String seedTracks) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/recommendations").addQueryParameter("seed_artists", String.valueOf(seedArtists)).addQueryParameter("seed_genres", String.valueOf(seedGenres)).addQueryParameter("seed_tracks", String.valueOf(seedTracks));
    }

    public GetRecommendationsRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public GetRecommendationsRequest market(String market) {
        this.request.addQueryParameter("market", String.valueOf(market));
        return this;
    }

    public GetRecommendationsRequest minAcousticness(Number minAcousticness) {
        this.request.addQueryParameter("min_acousticness", String.valueOf(minAcousticness));
        return this;
    }

    public GetRecommendationsRequest maxAcousticness(Number maxAcousticness) {
        this.request.addQueryParameter("max_acousticness", String.valueOf(maxAcousticness));
        return this;
    }

    public GetRecommendationsRequest targetAcousticness(Number targetAcousticness) {
        this.request.addQueryParameter("target_acousticness", String.valueOf(targetAcousticness));
        return this;
    }

    public GetRecommendationsRequest minDanceability(Number minDanceability) {
        this.request.addQueryParameter("min_danceability", String.valueOf(minDanceability));
        return this;
    }

    public GetRecommendationsRequest maxDanceability(Number maxDanceability) {
        this.request.addQueryParameter("max_danceability", String.valueOf(maxDanceability));
        return this;
    }

    public GetRecommendationsRequest targetDanceability(Number targetDanceability) {
        this.request.addQueryParameter("target_danceability", String.valueOf(targetDanceability));
        return this;
    }

    public GetRecommendationsRequest minDurationMs(int minDurationMs) {
        this.request.addQueryParameter("min_duration_ms", String.valueOf(minDurationMs));
        return this;
    }

    public GetRecommendationsRequest maxDurationMs(int maxDurationMs) {
        this.request.addQueryParameter("max_duration_ms", String.valueOf(maxDurationMs));
        return this;
    }

    public GetRecommendationsRequest targetDurationMs(int targetDurationMs) {
        this.request.addQueryParameter("target_duration_ms", String.valueOf(targetDurationMs));
        return this;
    }

    public GetRecommendationsRequest minEnergy(Number minEnergy) {
        this.request.addQueryParameter("min_energy", String.valueOf(minEnergy));
        return this;
    }

    public GetRecommendationsRequest maxEnergy(Number maxEnergy) {
        this.request.addQueryParameter("max_energy", String.valueOf(maxEnergy));
        return this;
    }

    public GetRecommendationsRequest targetEnergy(Number targetEnergy) {
        this.request.addQueryParameter("target_energy", String.valueOf(targetEnergy));
        return this;
    }

    public GetRecommendationsRequest minInstrumentalness(Number minInstrumentalness) {
        this.request.addQueryParameter("min_instrumentalness", String.valueOf(minInstrumentalness));
        return this;
    }

    public GetRecommendationsRequest maxInstrumentalness(Number maxInstrumentalness) {
        this.request.addQueryParameter("max_instrumentalness", String.valueOf(maxInstrumentalness));
        return this;
    }

    public GetRecommendationsRequest targetInstrumentalness(Number targetInstrumentalness) {
        this.request.addQueryParameter("target_instrumentalness", String.valueOf(targetInstrumentalness));
        return this;
    }

    public GetRecommendationsRequest minKey(int minKey) {
        this.request.addQueryParameter("min_key", String.valueOf(minKey));
        return this;
    }

    public GetRecommendationsRequest maxKey(int maxKey) {
        this.request.addQueryParameter("max_key", String.valueOf(maxKey));
        return this;
    }

    public GetRecommendationsRequest targetKey(int targetKey) {
        this.request.addQueryParameter("target_key", String.valueOf(targetKey));
        return this;
    }

    public GetRecommendationsRequest minLiveness(Number minLiveness) {
        this.request.addQueryParameter("min_liveness", String.valueOf(minLiveness));
        return this;
    }

    public GetRecommendationsRequest maxLiveness(Number maxLiveness) {
        this.request.addQueryParameter("max_liveness", String.valueOf(maxLiveness));
        return this;
    }

    public GetRecommendationsRequest targetLiveness(Number targetLiveness) {
        this.request.addQueryParameter("target_liveness", String.valueOf(targetLiveness));
        return this;
    }

    public GetRecommendationsRequest minLoudness(Number minLoudness) {
        this.request.addQueryParameter("min_loudness", String.valueOf(minLoudness));
        return this;
    }

    public GetRecommendationsRequest maxLoudness(Number maxLoudness) {
        this.request.addQueryParameter("max_loudness", String.valueOf(maxLoudness));
        return this;
    }

    public GetRecommendationsRequest targetLoudness(Number targetLoudness) {
        this.request.addQueryParameter("target_loudness", String.valueOf(targetLoudness));
        return this;
    }

    public GetRecommendationsRequest minMode(int minMode) {
        this.request.addQueryParameter("min_mode", String.valueOf(minMode));
        return this;
    }

    public GetRecommendationsRequest maxMode(int maxMode) {
        this.request.addQueryParameter("max_mode", String.valueOf(maxMode));
        return this;
    }

    public GetRecommendationsRequest targetMode(int targetMode) {
        this.request.addQueryParameter("target_mode", String.valueOf(targetMode));
        return this;
    }

    public GetRecommendationsRequest minPopularity(int minPopularity) {
        this.request.addQueryParameter("min_popularity", String.valueOf(minPopularity));
        return this;
    }

    public GetRecommendationsRequest maxPopularity(int maxPopularity) {
        this.request.addQueryParameter("max_popularity", String.valueOf(maxPopularity));
        return this;
    }

    public GetRecommendationsRequest targetPopularity(int targetPopularity) {
        this.request.addQueryParameter("target_popularity", String.valueOf(targetPopularity));
        return this;
    }

    public GetRecommendationsRequest minSpeechiness(Number minSpeechiness) {
        this.request.addQueryParameter("min_speechiness", String.valueOf(minSpeechiness));
        return this;
    }

    public GetRecommendationsRequest maxSpeechiness(Number maxSpeechiness) {
        this.request.addQueryParameter("max_speechiness", String.valueOf(maxSpeechiness));
        return this;
    }

    public GetRecommendationsRequest targetSpeechiness(Number targetSpeechiness) {
        this.request.addQueryParameter("target_speechiness", String.valueOf(targetSpeechiness));
        return this;
    }

    public GetRecommendationsRequest minTempo(Number minTempo) {
        this.request.addQueryParameter("min_tempo", String.valueOf(minTempo));
        return this;
    }

    public GetRecommendationsRequest maxTempo(Number maxTempo) {
        this.request.addQueryParameter("max_tempo", String.valueOf(maxTempo));
        return this;
    }

    public GetRecommendationsRequest targetTempo(Number targetTempo) {
        this.request.addQueryParameter("target_tempo", String.valueOf(targetTempo));
        return this;
    }

    public GetRecommendationsRequest minTimeSignature(int minTimeSignature) {
        this.request.addQueryParameter("min_time_signature", String.valueOf(minTimeSignature));
        return this;
    }

    public GetRecommendationsRequest maxTimeSignature(int maxTimeSignature) {
        this.request.addQueryParameter("max_time_signature", String.valueOf(maxTimeSignature));
        return this;
    }

    public GetRecommendationsRequest targetTimeSignature(int targetTimeSignature) {
        this.request.addQueryParameter("target_time_signature", String.valueOf(targetTimeSignature));
        return this;
    }

    public GetRecommendationsRequest minValence(Number minValence) {
        this.request.addQueryParameter("min_valence", String.valueOf(minValence));
        return this;
    }

    public GetRecommendationsRequest maxValence(Number maxValence) {
        this.request.addQueryParameter("max_valence", String.valueOf(maxValence));
        return this;
    }

    public GetRecommendationsRequest targetValence(Number targetValence) {
        this.request.addQueryParameter("target_valence", String.valueOf(targetValence));
        return this;
    }

    public ApiCall<Recommendations> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

