/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.browse;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.Category;

public class GetCategoryRequest {
    private static final TypeReference<Category> RESPONSE_TYPE = new TypeReference<Category>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetCategoryRequest(ApiClient apiClient, String categoryId) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/browse/categories/{category_id}").addPathParameter("category_id", String.valueOf(categoryId));
    }

    public GetCategoryRequest country(String country) {
        this.request.addQueryParameter("country", String.valueOf(country));
        return this;
    }

    public GetCategoryRequest locale(String locale) {
        this.request.addQueryParameter("locale", String.valueOf(locale));
        return this;
    }

    public ApiCall<Category> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

