/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.artists;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.Paging;
import de.sonallux.spotify.api.models.SimplifiedAlbum;

public class GetArtistsAlbumsRequest {
    private static final TypeReference<Paging<SimplifiedAlbum>> RESPONSE_TYPE = new TypeReference<Paging<SimplifiedAlbum>>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetArtistsAlbumsRequest(ApiClient apiClient, String id) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/artists/{id}/albums").addPathParameter("id", String.valueOf(id));
    }

    public GetArtistsAlbumsRequest includeGroups(String includeGroups) {
        this.request.addQueryParameter("include_groups", String.valueOf(includeGroups));
        return this;
    }

    public GetArtistsAlbumsRequest market(String market) {
        this.request.addQueryParameter("market", String.valueOf(market));
        return this;
    }

    public GetArtistsAlbumsRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public GetArtistsAlbumsRequest offset(int offset) {
        this.request.addQueryParameter("offset", String.valueOf(offset));
        return this;
    }

    public ApiCall<Paging<SimplifiedAlbum>> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

