/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.albums;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.Paging;
import de.sonallux.spotify.api.models.SimplifiedTrack;

public class GetAlbumsTracksRequest {
    private static final TypeReference<Paging<SimplifiedTrack>> RESPONSE_TYPE = new TypeReference<Paging<SimplifiedTrack>>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetAlbumsTracksRequest(ApiClient apiClient, String id) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/albums/{id}/tracks").addPathParameter("id", String.valueOf(id));
    }

    public GetAlbumsTracksRequest market(String market) {
        this.request.addQueryParameter("market", String.valueOf(market));
        return this;
    }

    public GetAlbumsTracksRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public GetAlbumsTracksRequest offset(int offset) {
        this.request.addQueryParameter("offset", String.valueOf(offset));
        return this;
    }

    public ApiCall<Paging<SimplifiedTrack>> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

