/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.sonallux.spotify.api.SpotifyWebApi;
import de.sonallux.spotify.api.authorization.ApiAuthorizationProvider;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.AuthorizationAddingInterceptor;
import de.sonallux.spotify.api.http.AuthorizedApiCall;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class SpotifyWebApiBuilder {
    private HttpUrl baseUrl;
    private Call.Factory callFactory;
    private ObjectMapper objectMapper;
    private ApiAuthorizationProvider authorizationProvider;

    public SpotifyWebApiBuilder baseUrl(String baseUrl) {
        Objects.requireNonNull(baseUrl, "baseUrl == null");
        return this.baseUrl(HttpUrl.get((String)baseUrl));
    }

    public SpotifyWebApiBuilder baseUrl(HttpUrl baseUrl) {
        this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl == null");
        return this;
    }

    public SpotifyWebApiBuilder httpClient(OkHttpClient httpClient) {
        return this.callFactory((Call.Factory)Objects.requireNonNull(httpClient, "httpClient == null"));
    }

    public SpotifyWebApiBuilder callFactory(Call.Factory factory) {
        this.callFactory = Objects.requireNonNull(factory, "factory == null");
        return this;
    }

    public SpotifyWebApiBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper == null");
        return this;
    }

    public SpotifyWebApiBuilder authorization(ApiAuthorizationProvider authorizationProvider) {
        this.authorizationProvider = Objects.requireNonNull(authorizationProvider, "authorizationProvider == null");
        return this;
    }

    public SpotifyWebApi build() {
        if (this.baseUrl == null) {
            this.baseUrl = SpotifyWebApi.SPOTIFY_WEB_API_ENDPOINT;
        }
        if (this.callFactory == null) {
            this.callFactory = this.authorizationProvider == null ? new OkHttpClient() : new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthorizationAddingInterceptor(this.authorizationProvider)).build();
        }
        if (this.objectMapper == null) {
            this.objectMapper = this.createDefaultObjectMapper();
        }
        ApiClient.Builder apiClientBuilder = ApiClient.builder().baseUrl(this.baseUrl).callFactory(this.callFactory).objectMapper(this.objectMapper);
        if (this.authorizationProvider != null) {
            apiClientBuilder.apiCallFactory(new AuthorizedApiCall.Factory(this.authorizationProvider));
        }
        return new SpotifyWebApi(apiClientBuilder.build());
    }

    private ObjectMapper createDefaultObjectMapper() {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).registerModule((Module)new JavaTimeModule());
    }
}

