/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api;

import de.sonallux.spotify.api.SpotifyWebApiBuilder;
import de.sonallux.spotify.api.apis.AlbumsApi;
import de.sonallux.spotify.api.apis.ArtistsApi;
import de.sonallux.spotify.api.apis.BrowseApi;
import de.sonallux.spotify.api.apis.EpisodesApi;
import de.sonallux.spotify.api.apis.FollowApi;
import de.sonallux.spotify.api.apis.LibraryApi;
import de.sonallux.spotify.api.apis.MarketsApi;
import de.sonallux.spotify.api.apis.PersonalizationApi;
import de.sonallux.spotify.api.apis.PlayerApi;
import de.sonallux.spotify.api.apis.PlaylistsApi;
import de.sonallux.spotify.api.apis.SearchApi;
import de.sonallux.spotify.api.apis.ShowsApi;
import de.sonallux.spotify.api.apis.TracksApi;
import de.sonallux.spotify.api.apis.UsersProfileApi;
import de.sonallux.spotify.api.http.ApiClient;
import okhttp3.HttpUrl;

public class SpotifyWebApi {
    public static final HttpUrl SPOTIFY_WEB_API_ENDPOINT = HttpUrl.get((String)"https://api.spotify.com/v1");
    private final AlbumsApi albumsApi;
    private final ArtistsApi artistsApi;
    private final BrowseApi browseApi;
    private final EpisodesApi episodesApi;
    private final FollowApi followApi;
    private final LibraryApi libraryApi;
    private final MarketsApi marketsApi;
    private final PersonalizationApi personalizationApi;
    private final PlayerApi playerApi;
    private final PlaylistsApi playlistsApi;
    private final SearchApi searchApi;
    private final ShowsApi showsApi;
    private final TracksApi tracksApi;
    private final UsersProfileApi usersProfileApi;

    SpotifyWebApi(ApiClient apiClient) {
        this.albumsApi = new AlbumsApi(apiClient);
        this.artistsApi = new ArtistsApi(apiClient);
        this.browseApi = new BrowseApi(apiClient);
        this.episodesApi = new EpisodesApi(apiClient);
        this.followApi = new FollowApi(apiClient);
        this.libraryApi = new LibraryApi(apiClient);
        this.marketsApi = new MarketsApi(apiClient);
        this.personalizationApi = new PersonalizationApi(apiClient);
        this.playerApi = new PlayerApi(apiClient);
        this.playlistsApi = new PlaylistsApi(apiClient);
        this.searchApi = new SearchApi(apiClient);
        this.showsApi = new ShowsApi(apiClient);
        this.tracksApi = new TracksApi(apiClient);
        this.usersProfileApi = new UsersProfileApi(apiClient);
    }

    public static SpotifyWebApiBuilder builder() {
        return new SpotifyWebApiBuilder();
    }

    public AlbumsApi getAlbumsApi() {
        return this.albumsApi;
    }

    public ArtistsApi getArtistsApi() {
        return this.artistsApi;
    }

    public BrowseApi getBrowseApi() {
        return this.browseApi;
    }

    public EpisodesApi getEpisodesApi() {
        return this.episodesApi;
    }

    public FollowApi getFollowApi() {
        return this.followApi;
    }

    public LibraryApi getLibraryApi() {
        return this.libraryApi;
    }

    public MarketsApi getMarketsApi() {
        return this.marketsApi;
    }

    public PersonalizationApi getPersonalizationApi() {
        return this.personalizationApi;
    }

    public PlayerApi getPlayerApi() {
        return this.playerApi;
    }

    public PlaylistsApi getPlaylistsApi() {
        return this.playlistsApi;
    }

    public SearchApi getSearchApi() {
        return this.searchApi;
    }

    public ShowsApi getShowsApi() {
        return this.showsApi;
    }

    public TracksApi getTracksApi() {
        return this.tracksApi;
    }

    public UsersProfileApi getUsersProfileApi() {
        return this.usersProfileApi;
    }
}

