/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.generator.java.util;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Markdown2Html {
    private static final Parser PARSER;
    private static final HtmlRenderer HTML_RENDERER;

    public static String convert(String markdown) {
        Document document = PARSER.parse(markdown);
        String html = HTML_RENDERER.render((Node)document);
        return html.replaceAll("<br />", "<br>");
    }

    public static String convertToSingleLine(String markdown) {
        return Markdown2Html.convert(markdown).replaceAll(">\n", ">").replaceAll("\n", " ").trim();
    }

    public static List<String> convertToLines(String markdown) {
        String html = Markdown2Html.convert(markdown);
        return Arrays.stream(html.split("\n")).map(String::trim).collect(Collectors.toList());
    }

    static {
        MutableDataSet parserOptions = new MutableDataSet();
        PARSER = Parser.builder((DataHolder)parserOptions).build();
        MutableDataSet rendererOptions = new MutableDataSet();
        HTML_RENDERER = HtmlRenderer.builder((DataHolder)rendererOptions).build();
    }
}

