/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.generator.java.util;

import com.google.common.base.CaseFormat;
import de.sonallux.spotify.core.SpotifyWebApiObjectUtils;
import de.sonallux.spotify.core.SpotifyWebApiUtils;
import de.sonallux.spotify.core.model.SpotifyWebApiCategory;
import de.sonallux.spotify.core.model.SpotifyWebApiEndpoint;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;

public class JavaUtils {
    public static final List<String> RESERVED_WORDS = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "var", "void", "volatile", "while");

    public static String getObjectClassName(String type) {
        return type.replace("Object", "");
    }

    public static String getFileName(String className) {
        return className + ".java";
    }

    public static String escapeFieldName(String fieldName) {
        if (RESERVED_WORDS.contains(fieldName)) {
            return "_" + fieldName;
        }
        if (fieldName.contains("_")) {
            return (String)CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL).convert((Object)fieldName);
        }
        return fieldName;
    }

    public static String shrinkEndpointId(SpotifyWebApiEndpoint endpoint) {
        return endpoint.getId().replace("endpoint-", "").replace("-the-", "-").replace("-an-", "-").replace("-a-", "-");
    }

    public static String mapToJavaType(String type) {
        if ("Timestamp".equals(type)) {
            return "java.time.Instant";
        }
        if ("Object".equals(type)) {
            return "java.util.Map<String, Object>";
        }
        if ("Void".equals(type)) {
            return "Void";
        }
        Matcher matcher = SpotifyWebApiUtils.ARRAY_TYPE_PATTERN.matcher(type);
        if (matcher.matches()) {
            return "java.util.List<" + JavaUtils.mapToJavaType(matcher.group(1)) + ">";
        }
        matcher = SpotifyWebApiUtils.PAGING_OBJECT_TYPE_PATTERN.matcher(type);
        if (matcher.matches()) {
            return "Paging<" + JavaUtils.mapToJavaType(matcher.group(1)) + ">";
        }
        matcher = SpotifyWebApiUtils.CURSOR_PAGING_OBJECT_TYPE_PATTERN.matcher(type);
        if (matcher.matches()) {
            return "CursorPaging<" + JavaUtils.mapToJavaType(matcher.group(1)) + ">";
        }
        if (type.contains(" | ")) {
            if (Arrays.stream(type.split(" \\| ")).allMatch(SpotifyWebApiObjectUtils.BASE_OBJECT_NAMES::contains)) {
                return "BaseObject";
            }
            return "java.util.Map<String, Object>";
        }
        return JavaUtils.getObjectClassName(type);
    }

    public static String mapToPrimitiveJavaType(String type) {
        if ("String".equals(type)) {
            return "String";
        }
        if ("Boolean".equals(type)) {
            return "boolean";
        }
        if ("Integer".equals(type)) {
            return "int";
        }
        if ("Float".equals(type)) {
            return "float";
        }
        return JavaUtils.mapToJavaType(type);
    }

    public static String getClassName(SpotifyWebApiCategory category) {
        return category.getName().replace(" ", "").replace("API", "Api");
    }

    public static String getEndpointRequestBuilderName(SpotifyWebApiEndpoint endpoint) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, JavaUtils.shrinkEndpointId(endpoint)) + "Request";
    }
}

