/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.generator.java.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.nio.file.Path;
import java.util.Arrays;

public class JavaPackage {
    private final String[] packageNames;

    private JavaPackage(String ... packageNames) {
        this.packageNames = packageNames;
    }

    public static JavaPackage fromNames(String ... packageNames) {
        Preconditions.checkArgument((boolean)JavaPackage.isValidJavaPackageName(packageNames), (Object)"Invalid java package");
        return new JavaPackage(packageNames);
    }

    public static JavaPackage fromPackage(String packageName) {
        Preconditions.checkArgument((packageName != null ? 1 : 0) != 0);
        String[] packageNames = packageName.split("\\.");
        Preconditions.checkArgument((boolean)JavaPackage.isValidJavaPackageName(packageNames), (Object)"Invalid java package");
        return new JavaPackage(packageNames);
    }

    private static boolean isValidJavaPackageName(String[] packageNames) {
        if (packageNames.length == 0) {
            return false;
        }
        for (String packageName : packageNames) {
            if (!Strings.isNullOrEmpty((String)packageName)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return String.join((CharSequence)".", this.packageNames);
    }

    public Path getPath() {
        return Path.of(this.packageNames[0], Arrays.copyOfRange(this.packageNames, 1, this.packageNames.length));
    }

    public JavaPackage parent() {
        return new JavaPackage(Arrays.copyOfRange(this.packageNames, 0, this.packageNames.length - 1));
    }

    public JavaPackage child(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Invalid java package");
        String[] newPackageNames = Arrays.copyOf(this.packageNames, this.packageNames.length + 1);
        newPackageNames[this.packageNames.length] = name;
        return new JavaPackage(newPackageNames);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaPackage)) {
            return false;
        }
        JavaPackage other = (JavaPackage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.packageNames, other.packageNames);
    }

    protected boolean canEqual(Object other) {
        return other instanceof JavaPackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.packageNames);
        return result;
    }
}

