/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.generator.java.templates;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import de.sonallux.spotify.core.SpotifyWebApiObjectUtils;
import de.sonallux.spotify.core.model.SpotifyWebApiObject;
import de.sonallux.spotify.generator.java.templates.AbstractTemplate;
import de.sonallux.spotify.generator.java.util.JavaPackage;
import de.sonallux.spotify.generator.java.util.JavaUtils;
import de.sonallux.spotify.generator.java.util.Markdown2Html;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ObjectTemplate
extends AbstractTemplate<SpotifyWebApiObject> {
    @Override
    public String templateName() {
        return "object";
    }

    @Override
    JavaPackage getJavaPackage(SpotifyWebApiObject object, JavaPackage basePackage) {
        return basePackage.child("models");
    }

    @Override
    public String getFileName(SpotifyWebApiObject object) {
        return JavaUtils.getFileName(this.getClassName(object));
    }

    @Override
    public Map<String, Object> buildContext(SpotifyWebApiObject object, Map<String, Object> context) {
        if (SpotifyWebApiObjectUtils.removeBaseProperties((SpotifyWebApiObject)object)) {
            context.put("extendsBaseObject", true);
            context.put("superClass", "BaseObject");
        }
        context.put("name", object.getName());
        context.put("className", this.getClassName(object));
        context.put("properties", object.getProperties().stream().map(this::buildPropertyContext).collect(Collectors.toList()));
        if (!Strings.isNullOrEmpty((String)object.getLink())) {
            context.put("documentationLink", object.getLink());
        }
        if (object.getProperties().size() == 0) {
            context.put("superClass", "java.util.HashMap<String, String>");
        }
        if ("PagingObject".equals(object.getName()) || "CursorPagingObject".equals(object.getName())) {
            this.fixContextForPaging(context);
        }
        return context;
    }

    private String getClassName(SpotifyWebApiObject object) {
        return JavaUtils.getObjectClassName(object.getName());
    }

    private Map<String, Object> buildPropertyContext(SpotifyWebApiObject.Property property) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String propertyName = property.getName();
        if (JavaUtils.RESERVED_WORDS.contains(propertyName)) {
            context.put("isReservedKeywordProperty", true);
            context.put("fieldName", "_" + propertyName);
        } else {
            context.put("fieldName", CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL).convert((Object)propertyName));
        }
        String description = property.getDescription();
        if (description != null && !description.isBlank()) {
            context.put("hasDescription", true);
            context.put("description", Markdown2Html.convertToLines(description));
        }
        context.put("type", JavaUtils.mapToPrimitiveJavaType(property.getType()));
        return context;
    }

    private void fixContextForPaging(Map<String, Object> context) {
        context.put("className", context.get("className") + "<T>");
        List properties = (List)context.get("properties");
        for (Map property : properties) {
            if (!"items".equals(property.get("fieldName"))) continue;
            property.put("type", "java.util.List<T>");
        }
    }
}

