/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.generator.java.templates;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.google.common.base.CaseFormat;
import de.sonallux.spotify.core.EndpointHelper;
import de.sonallux.spotify.core.model.SpotifyWebApiCategory;
import de.sonallux.spotify.core.model.SpotifyWebApiEndpoint;
import de.sonallux.spotify.generator.java.util.JavaPackage;
import de.sonallux.spotify.generator.java.util.JavaUtils;
import de.sonallux.spotify.generator.java.util.Markdown2Html;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ApiTemplate {
    private Mustache apiTemplate;
    private Mustache requestTemplate;
    private Path outputFolder;

    public ApiTemplate loadTemplate(MustacheFactory mustacheFactory) {
        this.apiTemplate = mustacheFactory.compile("templates/api.mustache");
        this.requestTemplate = mustacheFactory.compile("templates/request.mustache");
        return this;
    }

    public void generate(SpotifyWebApiCategory category, Path outputFolder, JavaPackage basePackage) throws IOException {
        this.outputFolder = outputFolder;
        JavaPackage apisJavaPackage = basePackage.child("apis");
        String className = JavaUtils.getClassName(category);
        JavaPackage requestsJavaPackage = apisJavaPackage.child(className.replace("Api", "").toLowerCase());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("package", apisJavaPackage.getName());
        context.put("requestsPackage", requestsJavaPackage.getName());
        context.put("name", category.getName());
        context.put("className", className);
        context.put("documentationLink", category.getLink());
        ArrayList<Map<String, Object>> endpointContexts = new ArrayList<Map<String, Object>>();
        for (SpotifyWebApiEndpoint endpoint : category.getEndpointList()) {
            endpointContexts.add(this.buildEndpointContext(endpoint, requestsJavaPackage));
        }
        context.put("endpoints", endpointContexts);
        Path packageFolder = this.getPackageFolder(outputFolder, apisJavaPackage);
        Path outputFile = packageFolder.resolve(JavaUtils.getFileName(className));
        this.generateFile(outputFile, this.apiTemplate, context);
    }

    private Path getPackageFolder(Path baseFolder, JavaPackage javaPackage) throws IOException {
        Path packageFolder = baseFolder.resolve(javaPackage.getPath());
        Files.createDirectories(packageFolder, new FileAttribute[0]);
        return packageFolder;
    }

    private void generateFile(Path outputFile, Mustache mustacheTemplate, Object scope) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            mustacheTemplate.execute((Writer)writer, scope);
        }
    }

    private Map<String, Object> buildEndpointContext(SpotifyWebApiEndpoint endpoint, JavaPackage javaPackage) throws IOException {
        List<Parameter> requiredParameters = this.generateEndpointRequest(endpoint, javaPackage);
        HashMap<String, Object> context = new HashMap<String, Object>();
        String methodName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, JavaUtils.shrinkEndpointId(endpoint));
        context.put("methodName", methodName);
        context.put("name", endpoint.getName());
        context.put("description", Markdown2Html.convertToSingleLine(endpoint.getDescription()));
        context.put("requestBuilder", JavaUtils.getEndpointRequestBuilderName(endpoint));
        context.put("requiredParameters", requiredParameters.stream().map(Parameter::asMethodParameter).collect(Collectors.joining(", ")));
        context.put("javaDocParameters", requiredParameters.stream().map(Parameter::asJavaDoc).collect(Collectors.toList()));
        context.put("arguments", Stream.concat(Stream.of(new Parameter("apiClient", "ApiClient", "")), requiredParameters.stream()).map(Parameter::getJavaName).collect(Collectors.joining(", ")));
        return context;
    }

    private List<Parameter> generateEndpointRequest(SpotifyWebApiEndpoint endpoint, JavaPackage javaPackage) throws IOException {
        EndpointHelper.fixDuplicateEndpointParameters((SpotifyWebApiEndpoint)endpoint);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("package", javaPackage.getName());
        context.put("name", endpoint.getName() + " request");
        context.put("documentationLink", endpoint.getLink());
        context.put("className", JavaUtils.getEndpointRequestBuilderName(endpoint));
        context.put("httpMethod", endpoint.getHttpMethod());
        context.put("path", endpoint.getPath());
        context.put("responseType", this.getResponseType(endpoint));
        context.put("responseDescription", Markdown2Html.convertToLines(endpoint.getResponseDescription()));
        if (endpoint.getNotes() != null) {
            context.put("hasNotes", true);
            context.put("notes", Markdown2Html.convertToLines(endpoint.getNotes()));
        }
        if (endpoint.getScopes().size() > 0) {
            context.put("scopes", String.join((CharSequence)", ", endpoint.getScopes()));
        }
        ArrayList<Parameter> requiredPathParameters = new ArrayList<Parameter>();
        ArrayList<Parameter> requiredQueryParameters = new ArrayList<Parameter>();
        ArrayList<Parameter> requiredBodyParameters = new ArrayList<Parameter>();
        ArrayList<Parameter> optionalPathParameters = new ArrayList<Parameter>();
        ArrayList<Parameter> optionalQueryParameters = new ArrayList<Parameter>();
        ArrayList<Parameter> optionalBodyParameters = new ArrayList<Parameter>();
        for (SpotifyWebApiEndpoint.Parameter parameter : endpoint.getParameters()) {
            switch (parameter.getLocation()) {
                case PATH: {
                    this.addParameter(parameter, requiredPathParameters, optionalPathParameters);
                    break;
                }
                case QUERY: {
                    this.addParameter(parameter, requiredQueryParameters, optionalQueryParameters);
                    break;
                }
                case BODY: {
                    this.addParameter(parameter, requiredBodyParameters, optionalBodyParameters);
                }
            }
        }
        context.put("requiredPathParameters", requiredPathParameters);
        context.put("requiredQueryParameters", requiredQueryParameters);
        context.put("requiredBodyParameters", requiredBodyParameters);
        context.put("optionalPathParameters", optionalPathParameters);
        context.put("optionalQueryParameters", optionalQueryParameters);
        context.put("optionalBodyParameters", optionalBodyParameters);
        ArrayList<Parameter> requiredParameterList = new ArrayList<Parameter>();
        requiredParameterList.add(new Parameter("apiClient", "ApiClient", "The API client"));
        requiredParameterList.addAll(requiredPathParameters);
        requiredParameterList.addAll(requiredQueryParameters);
        requiredParameterList.addAll(requiredBodyParameters);
        context.put("requiredParameters", requiredParameterList.stream().map(Parameter::asMethodParameter).collect(Collectors.joining(", ")));
        context.put("requiredJavaDocParameters", requiredParameterList.stream().map(Parameter::asJavaDoc).collect(Collectors.toList()));
        optionalQueryParameters.stream().filter(p -> "additional_types".equals(p.getName())).findFirst().ifPresent(additionalTypesParameter -> {
            additionalTypesParameter.setDefaultValue("\"track,episode\"");
            context.put("parametersWithDefaultValue", List.of(additionalTypesParameter));
        });
        Path packageFolder = this.getPackageFolder(this.outputFolder, javaPackage);
        Path outputFile = packageFolder.resolve(JavaUtils.getFileName(JavaUtils.getEndpointRequestBuilderName(endpoint)));
        this.generateFile(outputFile, this.requestTemplate, context);
        return requiredParameterList.subList(1, requiredParameterList.size());
    }

    private void addParameter(SpotifyWebApiEndpoint.Parameter parameter, List<Parameter> requiredParams, List<Parameter> optionalParams) {
        Parameter mappedParameter = new Parameter(parameter.getName(), parameter.getType(), parameter.getDescription());
        if (parameter.isRequired()) {
            requiredParams.add(mappedParameter);
        } else {
            optionalParams.add(mappedParameter);
        }
    }

    private String getResponseType(SpotifyWebApiEndpoint endpoint) {
        if (endpoint.getResponseTypes().stream().map(SpotifyWebApiEndpoint.ResponseType::getType).distinct().count() == 1L) {
            return JavaUtils.mapToPrimitiveJavaType(((SpotifyWebApiEndpoint.ResponseType)endpoint.getResponseTypes().get(0)).getType());
        }
        List nonVoidResponseTypes = endpoint.getResponseTypes().stream().map(SpotifyWebApiEndpoint.ResponseType::getType).filter(t -> !"Void".equals(t)).distinct().collect(Collectors.toList());
        if (nonVoidResponseTypes.size() == 1) {
            return JavaUtils.mapToPrimitiveJavaType(((SpotifyWebApiEndpoint.ResponseType)endpoint.getResponseTypes().get(0)).getType());
        }
        return "";
    }

    private static class Parameter {
        private String name;
        private String javaName;
        private String type;
        private String description;
        private String defaultValue;

        public Parameter(String name, String type, String description) {
            this.name = name;
            this.javaName = JavaUtils.escapeFieldName(name);
            this.type = JavaUtils.mapToPrimitiveJavaType(type);
            this.description = Markdown2Html.convertToSingleLine(description);
            this.defaultValue = null;
        }

        public String asMethodParameter() {
            return this.type + " " + this.javaName;
        }

        public String asJavaDoc() {
            return "@param " + this.javaName + " " + this.description;
        }

        public String getName() {
            return this.name;
        }

        public String getJavaName() {
            return this.javaName;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setJavaName(String javaName) {
            this.javaName = javaName;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

