/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.generator.java.templates;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import de.sonallux.spotify.generator.java.util.JavaPackage;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTemplate<T> {
    private Mustache mustacheTemplate;
    private JavaPackage basePackage;

    public AbstractTemplate<T> loadTemplate(MustacheFactory mustacheFactory) {
        String fileName = String.format("templates/%s.mustache", this.templateName());
        this.mustacheTemplate = mustacheFactory.compile(fileName);
        return this;
    }

    public void generate(T t, Path outputFolder, JavaPackage basePackage) throws IOException {
        this.basePackage = basePackage;
        JavaPackage javaPackage = this.getJavaPackage(t, basePackage);
        Path fullPath = outputFolder.resolve(javaPackage.getPath());
        Files.createDirectories(fullPath, new FileAttribute[0]);
        Path outputFile = fullPath.resolve(this.getFileName(t));
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("package", javaPackage.getName());
            context.put("basePackage", basePackage.getName());
            this.mustacheTemplate.execute((Writer)writer, this.buildContext(t, context));
        }
    }

    abstract String templateName();

    abstract String getFileName(T var1);

    abstract JavaPackage getJavaPackage(T var1, JavaPackage var2);

    abstract Map<String, Object> buildContext(T var1, Map<String, Object> var2);

    public JavaPackage getBasePackage() {
        return this.basePackage;
    }
}

