/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.generator.java;

import com.github.mustachejava.MustacheFactory;
import de.sonallux.spotify.core.EndpointSplitter;
import de.sonallux.spotify.core.SpotifyWebApiObjectUtils;
import de.sonallux.spotify.core.model.SpotifyWebApi;
import de.sonallux.spotify.core.model.SpotifyWebApiCategory;
import de.sonallux.spotify.core.model.SpotifyWebApiObject;
import de.sonallux.spotify.generator.java.GeneratorException;
import de.sonallux.spotify.generator.java.NoEscapingMustacheFactory;
import de.sonallux.spotify.generator.java.templates.AbstractTemplate;
import de.sonallux.spotify.generator.java.templates.ApiTemplate;
import de.sonallux.spotify.generator.java.templates.BaseObjectTemplate;
import de.sonallux.spotify.generator.java.templates.ObjectTemplate;
import de.sonallux.spotify.generator.java.templates.ScopeTemplate;
import de.sonallux.spotify.generator.java.templates.SpotifyWebApiTemplate;
import de.sonallux.spotify.generator.java.util.JavaPackage;
import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaGenerator {
    private static final Logger log = LoggerFactory.getLogger(JavaGenerator.class);
    private final MustacheFactory mustacheFactory = new NoEscapingMustacheFactory();

    public void generate(SpotifyWebApi spotifyWebApi, Path outputFolder, JavaPackage javaPackage) throws IOException, GeneratorException {
        try {
            EndpointSplitter.splitEndpoints((SpotifyWebApi)spotifyWebApi);
        }
        catch (IllegalArgumentException e) {
            throw new GeneratorException("Failed to split endpoints", e);
        }
        AbstractTemplate<SpotifyWebApiObject> baseObjectTemplate = new BaseObjectTemplate().loadTemplate(this.mustacheFactory);
        baseObjectTemplate.generate(SpotifyWebApiObjectUtils.SPOTIFY_BASE_OBJECT, outputFolder, javaPackage);
        AbstractTemplate<SpotifyWebApiObject> objectTemplate = new ObjectTemplate().loadTemplate(this.mustacheFactory);
        for (SpotifyWebApiObject object : spotifyWebApi.getObjectList()) {
            objectTemplate.generate(object, outputFolder, javaPackage);
        }
        ApiTemplate apiTemplate = new ApiTemplate().loadTemplate(this.mustacheFactory);
        for (SpotifyWebApiCategory category : spotifyWebApi.getCategoryList()) {
            apiTemplate.generate(category, outputFolder, javaPackage);
        }
        new SpotifyWebApiTemplate().loadTemplate(this.mustacheFactory).generate(spotifyWebApi, outputFolder, javaPackage);
        new ScopeTemplate().loadTemplate(this.mustacheFactory).generate(spotifyWebApi.getScopes(), outputFolder, javaPackage);
    }
}

