/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.generator.java;

import de.sonallux.spotify.core.SpotifyWebApiUtils;
import de.sonallux.spotify.core.model.SpotifyWebApi;
import de.sonallux.spotify.generator.java.GeneratorException;
import de.sonallux.spotify.generator.java.JavaGenerator;
import de.sonallux.spotify.generator.java.util.JavaPackage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=ManifestVersionProvider.class)
public class CLI
implements Runnable {
    @CommandLine.Option(names={"-f", "--file"}, description={"The web API documentation file to a generate a Java wrapper for"})
    Path apiDocumentationFile;
    @CommandLine.Option(names={"-o", "--output"}, required=true, description={"The folder to output the generated files to"})
    Path outputFolder;
    @CommandLine.Option(names={"--clean"}, description={"Deletes all content from the output folder"})
    boolean shouldClean = false;
    @CommandLine.Option(names={"-p", "--package"}, required=true, description={"The Java package name"})
    String packageName = null;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Print usage help"})
    boolean helpRequested = false;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Print version information"})
    boolean versionRequested = false;

    @Override
    public void run() {
        SpotifyWebApi apiDocumentation = this.readSpotifyWebApi();
        try {
            if (CLI.hasFiles(this.outputFolder)) {
                if (this.shouldClean) {
                    CLI.deleteDirectory(this.outputFolder);
                } else {
                    System.err.println("Warning: output folder is not empty. Existing files will be overridden.");
                }
            }
            JavaPackage javaPackage = JavaPackage.fromPackage(this.packageName);
            new JavaGenerator().generate(apiDocumentation, this.outputFolder, javaPackage);
        }
        catch (IOException e) {
            System.err.println("Failed to write generated files: " + e.getMessage());
            System.exit(1);
        }
        catch (GeneratorException e) {
            System.err.println("Failed to generate Java wrapper: " + e.getMessage());
            System.exit(1);
        }
    }

    private static boolean hasFiles(Path dir) throws IOException {
        return Files.exists(dir, new LinkOption[0]) && Files.list(dir).findAny().isPresent();
    }

    private static void deleteDirectory(Path dir) throws IOException {
        try (Stream<Path> walk = Files.walk(dir, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    private SpotifyWebApi readSpotifyWebApi() {
        try {
            if (this.apiDocumentationFile == null) {
                return SpotifyWebApiUtils.load();
            }
            return SpotifyWebApiUtils.load((Path)this.apiDocumentationFile);
        }
        catch (IOException e) {
            System.err.println("Failed to read web API documentation file: " + e.getMessage());
            System.exit(1);
            return null;
        }
    }

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new CLI()).execute(args);
        System.exit(exitCode);
    }

    static class ManifestVersionProvider
    implements CommandLine.IVersionProvider {
        private static final String IMPLEMENTATION_TITLE = "spotify-web-api-java-generator";

        ManifestVersionProvider() {
        }

        public String[] getVersion() throws Exception {
            Enumeration<URL> resources = CLI.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try {
                    Manifest manifest = new Manifest(url.openStream());
                    Attributes attributes = manifest.getMainAttributes();
                    Object title = ManifestVersionProvider.get(attributes, "Implementation-Title");
                    if (!IMPLEMENTATION_TITLE.equals(title)) continue;
                    Object version = ManifestVersionProvider.get(attributes, "Implementation-Version");
                    return new String[]{title + " version \"" + version + "\""};
                }
                catch (IOException e) {
                    return new String[]{"Unable to read manifest from " + url + ": " + e};
                }
            }
            return new String[]{"spotify-web-api-java-generator version \"unknown\""};
        }

        private static Object get(Attributes attributes, String key) {
            return attributes.get(new Attributes.Name(key));
        }
    }
}

