/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.generator.openapi;

import com.fasterxml.jackson.databind.ObjectWriter;
import de.sonallux.spotify.core.SpotifyWebApiUtils;
import de.sonallux.spotify.core.model.SpotifyWebApi;
import de.sonallux.spotify.generator.openapi.OpenApiGenerator;
import de.sonallux.spotify.generator.openapi.validation.OpenApiValidator;
import de.sonallux.spotify.generator.openapi.validation.SchemaValidationError;
import de.sonallux.spotify.generator.openapi.validation.ValidationResponse;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=ManifestVersionProvider.class)
public class CLI
implements Runnable {
    private static final ObjectWriter OPEN_API_YAML = Yaml.pretty();
    @CommandLine.Option(names={"-f", "--file"}, required=true, description={"The web API documentation file to a generate a Java wrapper for"})
    Path apiDocumentationFile;
    @CommandLine.Option(names={"-o", "--output"}, required=true, description={"The file the OpenApi Specification should be written to"})
    Path outputFile;
    @CommandLine.Option(names={"--validate"}, description={"Validate the generated OpenApi Specification against the schema"})
    boolean shouldValidate = false;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Print usage help"})
    boolean helpRequested = false;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Print version information"})
    boolean versionRequested = false;

    @Override
    public void run() {
        SpotifyWebApi spotifyWebApi = this.readSpotifyWebApi();
        OpenAPI openAPI = new OpenApiGenerator().generate(spotifyWebApi);
        if (this.shouldValidate) {
            this.validate(openAPI);
        }
        try (OutputStream outputStream = Files.newOutputStream(this.outputFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            OPEN_API_YAML.writeValue(outputStream, (Object)openAPI);
        }
        catch (IOException e) {
            System.err.println("Failed to write generated file: " + e.getMessage());
            System.exit(1);
        }
    }

    private void validate(OpenAPI openAPI) {
        try {
            String openApiString = OPEN_API_YAML.writeValueAsString((Object)openAPI);
            boolean hasErrors = false;
            ValidationResponse result = new OpenApiValidator().validateByContent(openApiString);
            for (String string : result.getMessages()) {
                hasErrors = true;
                System.err.println("Validation result: " + string);
            }
            for (SchemaValidationError schemaValidationError : result.getSchemaValidationMessages()) {
                hasErrors = true;
                System.err.println("Validation result: " + schemaValidationError.getMessage() + " at " + schemaValidationError.getSchema().getPointer());
            }
            if (!hasErrors) {
                System.out.println("No errors on OpenApi Definition found");
                return;
            }
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Failed to execute validation: " + e.getMessage());
            System.exit(1);
        }
    }

    private SpotifyWebApi readSpotifyWebApi() {
        try {
            return SpotifyWebApiUtils.load((Path)this.apiDocumentationFile);
        }
        catch (IOException e) {
            System.err.println("Failed to read web API documentation file: " + e.getMessage());
            System.exit(1);
            return null;
        }
    }

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new CLI()).execute(args);
        System.exit(exitCode);
    }

    static class ManifestVersionProvider
    implements CommandLine.IVersionProvider {
        private static final String IMPLEMENTATION_TITLE = "spotify-web-api-generator-open-api";

        ManifestVersionProvider() {
        }

        public String[] getVersion() throws Exception {
            Enumeration<URL> resources = CLI.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try {
                    Manifest manifest = new Manifest(url.openStream());
                    Attributes attributes = manifest.getMainAttributes();
                    Object title = ManifestVersionProvider.get(attributes, "Implementation-Title");
                    if (!IMPLEMENTATION_TITLE.equals(title)) continue;
                    Object version = ManifestVersionProvider.get(attributes, "Implementation-Version");
                    return new String[]{IMPLEMENTATION_TITLE, version.toString()};
                }
                catch (IOException e) {
                    return new String[]{"Unable to read manifest from " + url + ": " + e};
                }
            }
            return new String[]{IMPLEMENTATION_TITLE, "unknown"};
        }

        private static Object get(Attributes attributes, String key) {
            return attributes.get(new Attributes.Name(key));
        }
    }
}

