/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.generator.openapi;

import de.sonallux.spotify.generator.openapi.CLI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionProvider {
    private static final Pattern VERSION_PATTERN = Pattern.compile("<version>([0-9.]+)</version>");

    public static String getVersion() {
        try {
            Matcher matcher;
            List<String> lines = Files.readAllLines(Path.of("./pom.xml", new String[0]));
            int versionLine = -1;
            for (int i = 0; i < lines.size(); ++i) {
                if (!"<artifactId>spotify-web-api-parent</artifactId>".equals(lines.get(i).trim())) continue;
                versionLine = i + 1;
                break;
            }
            if (versionLine != -1 && (matcher = VERSION_PATTERN.matcher(lines.get(versionLine).trim())).matches()) {
                return matcher.group(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            String[] versions = new CLI.ManifestVersionProvider().getVersion();
            if (!"unknown".equals(versions[1])) {
                return versions[1];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "unknown";
    }
}

