/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.core.model;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class SpotifyWebApiObject {
    @NonNull
    private String name;
    private String id;
    private String link;
    private List<Property> properties;

    public SpotifyWebApiObject(String name, String id, String link) {
        this(name, id, link, new ArrayList<Property>());
    }

    public SpotifyWebApiObject(String name) {
        this(name, null, null, new ArrayList<Property>());
    }

    public SpotifyWebApiObject(String name, String link) {
        this(name, null, link, new ArrayList<Property>());
    }

    public SpotifyWebApiObject(String name, List<Property> properties) {
        this(name, null, null, properties);
    }

    public SpotifyWebApiObject addProperty(Property property) {
        this.properties.add(property);
        return this;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getLink() {
        return this.link;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public SpotifyWebApiObject() {
    }

    public SpotifyWebApiObject(@NonNull String name, String id, String link, List<Property> properties) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.id = id;
        this.link = link;
        this.properties = properties;
    }

    public String toString() {
        return "SpotifyWebApiObject(name=" + this.getName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpotifyWebApiObject)) {
            return false;
        }
        SpotifyWebApiObject other = (SpotifyWebApiObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpotifyWebApiObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public static class Property {
        @NonNull
        private String name;
        private String type;
        private String description;

        public Property(String name, String type) {
            this(name, type, "");
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Property() {
        }

        public Property(@NonNull String name, String type, String description) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            this.type = type;
            this.description = description;
        }

        public String toString() {
            return "SpotifyWebApiObject.Property(name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Property;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

