/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.core.model;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class SpotifyWebApiEndpoint {
    @NonNull
    private String id;
    private String name;
    private String link;
    private String description;
    private String httpMethod;
    private String path;
    private List<Parameter> parameters;
    private String responseDescription;
    private List<String> scopes;
    private String notes;
    private List<ResponseType> responseTypes;

    public SpotifyWebApiEndpoint(@NonNull String id, String name, String link, String description, String httpMethod, String path, List<Parameter> parameters, String responseDescription, List<String> scopes, String notes) {
        this(id, name, link, description, httpMethod, path, parameters, responseDescription, scopes, notes, new ArrayList<ResponseType>());
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLink() {
        return this.link;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String getResponseDescription() {
        return this.responseDescription;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getNotes() {
        return this.notes;
    }

    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setResponseDescription(String responseDescription) {
        this.responseDescription = responseDescription;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public SpotifyWebApiEndpoint() {
    }

    public SpotifyWebApiEndpoint(@NonNull String id, String name, String link, String description, String httpMethod, String path, List<Parameter> parameters, String responseDescription, List<String> scopes, String notes, List<ResponseType> responseTypes) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.link = link;
        this.description = description;
        this.httpMethod = httpMethod;
        this.path = path;
        this.parameters = parameters;
        this.responseDescription = responseDescription;
        this.scopes = scopes;
        this.notes = notes;
        this.responseTypes = responseTypes;
    }

    public String toString() {
        return "SpotifyWebApiEndpoint(id=" + this.getId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpotifyWebApiEndpoint)) {
            return false;
        }
        SpotifyWebApiEndpoint other = (SpotifyWebApiEndpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpotifyWebApiEndpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public static class ResponseType {
        @NonNull
        private String type;
        private int status;
        private String description;

        @NonNull
        public String getType() {
            return this.type;
        }

        public int getStatus() {
            return this.status;
        }

        public String getDescription() {
            return this.description;
        }

        public void setType(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public ResponseType() {
        }

        public ResponseType(@NonNull String type, int status, String description) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            this.status = status;
            this.description = description;
        }
    }

    public static enum ParameterLocation {
        PATH,
        HEADER,
        QUERY,
        BODY;

    }

    public static class Parameter {
        @NonNull
        private ParameterLocation location;
        @NonNull
        private String name;
        private String description;
        private String type;
        private boolean required;

        @NonNull
        public ParameterLocation getLocation() {
            return this.location;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setLocation(@NonNull ParameterLocation location) {
            if (location == null) {
                throw new NullPointerException("location is marked non-null but is null");
            }
            this.location = location;
        }

        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public Parameter() {
        }

        public Parameter(@NonNull ParameterLocation location, @NonNull String name, String description, String type, boolean required) {
            if (location == null) {
                throw new NullPointerException("location is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.location = location;
            this.name = name;
            this.description = description;
            this.type = type;
            this.required = required;
        }

        public String toString() {
            return "SpotifyWebApiEndpoint.Parameter(location=" + this.getLocation() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter other = (Parameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ParameterLocation this$location = this.getLocation();
            ParameterLocation other$location = other.getLocation();
            if (this$location == null ? other$location != null : !((Object)((Object)this$location)).equals((Object)other$location)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ParameterLocation $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : ((Object)((Object)$location)).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

