/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.core.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sonallux.spotify.core.model.SpotifyWebApiEndpoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import lombok.NonNull;

public class SpotifyWebApiCategory {
    @NonNull
    private String id;
    private String name;
    private String link;
    private SortedMap<String, SpotifyWebApiEndpoint> endpoints;

    @JsonIgnore
    public List<SpotifyWebApiEndpoint> getEndpointList() {
        return new ArrayList<SpotifyWebApiEndpoint>(this.endpoints.values());
    }

    @JsonIgnore
    public Optional<SpotifyWebApiEndpoint> getEndpoint(String id) {
        return Optional.ofNullable((SpotifyWebApiEndpoint)this.endpoints.get(id));
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLink() {
        return this.link;
    }

    public SortedMap<String, SpotifyWebApiEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setEndpoints(SortedMap<String, SpotifyWebApiEndpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public SpotifyWebApiCategory() {
    }

    public SpotifyWebApiCategory(@NonNull String id, String name, String link, SortedMap<String, SpotifyWebApiEndpoint> endpoints) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.link = link;
        this.endpoints = endpoints;
    }

    public String toString() {
        return "SpotifyWebApiCategory(id=" + this.getId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpotifyWebApiCategory)) {
            return false;
        }
        SpotifyWebApiCategory other = (SpotifyWebApiCategory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpotifyWebApiCategory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

