/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.core.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sonallux.spotify.core.model.SpotifyAuthorizationScopes;
import de.sonallux.spotify.core.model.SpotifyWebApiCategory;
import de.sonallux.spotify.core.model.SpotifyWebApiObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.SortedMap;

public class SpotifyWebApi {
    private String apiDocumentationUrl;
    private String endpointUrl;
    private SortedMap<String, SpotifyWebApiObject> objects;
    private SortedMap<String, SpotifyWebApiCategory> categories;
    private SpotifyAuthorizationScopes scopes;

    @JsonIgnore
    public Collection<SpotifyWebApiObject> getObjectList() {
        return Collections.unmodifiableCollection(this.objects.values());
    }

    @JsonIgnore
    public Optional<SpotifyWebApiObject> getObject(String name) {
        return Optional.ofNullable((SpotifyWebApiObject)this.objects.get(name));
    }

    @JsonIgnore
    public Collection<SpotifyWebApiCategory> getCategoryList() {
        return Collections.unmodifiableCollection(this.categories.values());
    }

    @JsonIgnore
    public Optional<SpotifyWebApiCategory> getCategory(String id) {
        return Optional.ofNullable((SpotifyWebApiCategory)this.categories.get(id));
    }

    public String getApiDocumentationUrl() {
        return this.apiDocumentationUrl;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public SortedMap<String, SpotifyWebApiObject> getObjects() {
        return this.objects;
    }

    public SortedMap<String, SpotifyWebApiCategory> getCategories() {
        return this.categories;
    }

    public SpotifyAuthorizationScopes getScopes() {
        return this.scopes;
    }

    public void setApiDocumentationUrl(String apiDocumentationUrl) {
        this.apiDocumentationUrl = apiDocumentationUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public void setObjects(SortedMap<String, SpotifyWebApiObject> objects) {
        this.objects = objects;
    }

    public void setCategories(SortedMap<String, SpotifyWebApiCategory> categories) {
        this.categories = categories;
    }

    public void setScopes(SpotifyAuthorizationScopes scopes) {
        this.scopes = scopes;
    }

    public SpotifyWebApi() {
    }

    public SpotifyWebApi(String apiDocumentationUrl, String endpointUrl, SortedMap<String, SpotifyWebApiObject> objects, SortedMap<String, SpotifyWebApiCategory> categories, SpotifyAuthorizationScopes scopes) {
        this.apiDocumentationUrl = apiDocumentationUrl;
        this.endpointUrl = endpointUrl;
        this.objects = objects;
        this.categories = categories;
        this.scopes = scopes;
    }
}

