/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.core.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sonallux.spotify.core.model.SpotifyScope;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.SortedMap;

public class SpotifyAuthorizationScopes {
    private String url;
    private SortedMap<String, SpotifyScope> scopes;

    @JsonIgnore
    public Collection<SpotifyScope> getScopeList() {
        return Collections.unmodifiableCollection(this.scopes.values());
    }

    @JsonIgnore
    public Optional<SpotifyScope> getScope(String name) {
        return Optional.ofNullable((SpotifyScope)this.scopes.get(name));
    }

    public String getUrl() {
        return this.url;
    }

    public SortedMap<String, SpotifyScope> getScopes() {
        return this.scopes;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setScopes(SortedMap<String, SpotifyScope> scopes) {
        this.scopes = scopes;
    }

    public SpotifyAuthorizationScopes() {
    }

    public SpotifyAuthorizationScopes(String url, SortedMap<String, SpotifyScope> scopes) {
        this.url = url;
        this.scopes = scopes;
    }
}

