/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.core;

import de.sonallux.spotify.core.Yaml;
import de.sonallux.spotify.core.model.SpotifyWebApi;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class SpotifyWebApiUtils {
    public static final Pattern ARRAY_TYPE_PATTERN = Pattern.compile("^Array\\[(.+)]$");
    public static final Pattern PAGING_OBJECT_TYPE_PATTERN = Pattern.compile("^PagingObject\\[(.+)]$");
    public static final Pattern CURSOR_PAGING_OBJECT_TYPE_PATTERN = Pattern.compile("^CursorPagingObject\\[(.+)]$");

    public static SpotifyWebApi load() throws IOException {
        try (InputStream stream = SpotifyWebApiUtils.class.getResourceAsStream("/spotify-web-api.yml");){
            SpotifyWebApi spotifyWebApi = SpotifyWebApiUtils.load(stream);
            return spotifyWebApi;
        }
    }

    public static SpotifyWebApi load(Path path) throws IOException {
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            SpotifyWebApi spotifyWebApi = SpotifyWebApiUtils.load(stream);
            return spotifyWebApi;
        }
    }

    public static SpotifyWebApi load(InputStream inputStream) throws IOException {
        return (SpotifyWebApi)Yaml.create().readValue(inputStream, SpotifyWebApi.class);
    }
}

