/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.core;

import de.sonallux.spotify.core.EndpointSplitter;
import de.sonallux.spotify.core.model.SpotifyWebApi;
import de.sonallux.spotify.core.model.SpotifyWebApiEndpoint;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EndpointHelper {
    public static void splitEndpoints(SpotifyWebApi spotifyWebApi) throws IllegalArgumentException {
        EndpointSplitter.splitEndpoints(spotifyWebApi);
    }

    public static void fixDuplicateEndpointParameters(SpotifyWebApi spotifyWebApi) {
        spotifyWebApi.getCategoryList().stream().flatMap(c -> c.getEndpointList().stream()).forEach(EndpointHelper::fixDuplicateEndpointParameters);
    }

    public static void fixDuplicateEndpointParameters(SpotifyWebApiEndpoint endpoint) {
        Map<String, List> duplicates = endpoint.getParameters().stream().collect(Collectors.groupingBy(SpotifyWebApiEndpoint.Parameter::getName)).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        duplicates.forEach((paramName, parameters) -> {
            if (!parameters.stream().map(SpotifyWebApiEndpoint.Parameter::getLocation).sorted().collect(Collectors.toList()).equals(List.of(SpotifyWebApiEndpoint.ParameterLocation.QUERY, SpotifyWebApiEndpoint.ParameterLocation.BODY))) {
                System.err.println("Endpoint " + endpoint.getName() + " has unfixable duplicate parameters");
                return;
            }
            endpoint.getParameters().removeIf(p -> p.getLocation() == SpotifyWebApiEndpoint.ParameterLocation.QUERY && paramName.equals(p.getName()));
            for (SpotifyWebApiEndpoint.Parameter param : endpoint.getParameters()) {
                if (param.getLocation() == SpotifyWebApiEndpoint.ParameterLocation.BODY && paramName.equals(param.getName())) {
                    if ("endpoint-add-tracks-to-playlist".equals(endpoint.getId()) && "position".equals(param.getName())) continue;
                    param.setRequired(true);
                    continue;
                }
                if (param.getLocation() != SpotifyWebApiEndpoint.ParameterLocation.HEADER || !"Content-Type".equals(param.getName())) continue;
                param.setRequired(true);
            }
        });
    }
}

