/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.json.patching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import de.sonallux.json.patching.PatchException;
import de.sonallux.json.patching.PatchOperation;

public class TestOperation
extends PatchOperation {
    @JsonProperty
    protected final JsonNode value;

    @JsonCreator
    public TestOperation(@JsonProperty(value="path") String path, @JsonProperty(value="value") JsonNode value) {
        super("test", path);
        this.value = value;
    }

    @Override
    public JsonNode apply(JsonNode node) throws PatchException {
        try {
            JsonPath jsonPath = JsonPath.compile((String)this.path, (Predicate[])new Predicate[0]);
            JsonNode testNode = (JsonNode)jsonPath.read((Object)node, JSON_PATH_CONFIG);
            if (!this.value.equals((Object)testNode)) {
                throw new PatchException("Value differs from expected value");
            }
            return node.deepCopy();
        }
        catch (PathNotFoundException e) {
            if (this.value.isNull()) {
                return node.deepCopy();
            }
            throw new PatchException("Path did not exist", e);
        }
        catch (JsonPathException e) {
            throw this.wrapException(e);
        }
    }

    public JsonNode getValue() {
        return this.value;
    }
}

