/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.json.patching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import de.sonallux.json.patching.PatchException;
import de.sonallux.json.patching.PatchOperation;

public class PutOperation
extends PatchOperation {
    @JsonProperty
    protected final String key;
    @JsonProperty
    protected final JsonNode value;

    @JsonCreator
    public PutOperation(@JsonProperty(value="path") String path, @JsonProperty(value="key") String key, @JsonProperty(value="value") JsonNode value) {
        super("put", path);
        this.key = key;
        this.value = value;
    }

    @Override
    public JsonNode apply(JsonNode node) throws PatchException {
        try {
            JsonPath jsonPath = JsonPath.compile((String)this.path, (Predicate[])new Predicate[0]);
            return (JsonNode)jsonPath.put((Object)node.deepCopy(), this.key, (Object)this.value, JSON_PATH_CONFIG);
        }
        catch (JsonPathException e) {
            throw this.wrapException(e);
        }
    }

    public String getKey() {
        return this.key;
    }

    public JsonNode getValue() {
        return this.value;
    }
}

