/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.json.patching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import de.sonallux.json.patching.PatchException;
import de.sonallux.json.patching.PatchOperation;
import java.util.List;
import java.util.Objects;

public class Patch {
    private final String description;
    private final List<PatchOperation> operations;

    @JsonCreator
    public Patch(@JsonProperty(value="description") String description, @JsonProperty(value="operations") List<PatchOperation> operations) {
        this.description = description;
        this.operations = operations;
    }

    public JsonNode apply(JsonNode node) throws PatchException {
        Objects.requireNonNull(node);
        JsonNode ret = node;
        for (PatchOperation operation : this.operations) {
            ret = operation.apply(ret);
        }
        return ret;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PatchOperation> getOperations() {
        return this.operations;
    }
}

