/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.json.patching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import de.sonallux.json.patching.PatchException;
import de.sonallux.json.patching.PatchOperation;

public class SetOperation
extends PatchOperation {
    @JsonProperty
    protected final JsonNode value;

    @JsonCreator
    public SetOperation(@JsonProperty(value="path") String path, @JsonProperty(value="value") JsonNode value) {
        super("set", path);
        this.value = value;
    }

    @Override
    public JsonNode apply(JsonNode node) throws PatchException {
        try {
            JsonPath jsonPath = JsonPath.compile((String)this.path, (Predicate[])new Predicate[0]);
            return (JsonNode)jsonPath.set((Object)node.deepCopy(), (Object)this.value, JSON_PATH_CONFIG);
        }
        catch (JsonPathException e) {
            throw this.wrapException(e);
        }
    }

    public JsonNode getValue() {
        return this.value;
    }
}

