/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.json.patching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import de.sonallux.json.patching.PatchException;
import de.sonallux.json.patching.PatchOperation;

public class RenameOperation
extends PatchOperation {
    @JsonProperty
    protected final String oldKey;
    @JsonProperty
    protected final String newKey;

    @JsonCreator
    public RenameOperation(@JsonProperty(value="path") String path, @JsonProperty(value="oldKey") String oldKey, @JsonProperty(value="newKey") String newKey) {
        super("rename", path);
        this.oldKey = oldKey;
        this.newKey = newKey;
    }

    @Override
    public JsonNode apply(JsonNode node) throws PatchException {
        try {
            JsonPath jsonPath = JsonPath.compile((String)this.path, (Predicate[])new Predicate[0]);
            return (JsonNode)jsonPath.renameKey((Object)node.deepCopy(), this.oldKey, this.newKey, JSON_PATH_CONFIG);
        }
        catch (JsonPathException e) {
            throw this.wrapException(e);
        }
    }

    public String getOldKey() {
        return this.oldKey;
    }

    public String getNewKey() {
        return this.newKey;
    }
}

