/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.json.patching;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import de.sonallux.json.patching.AddOperation;
import de.sonallux.json.patching.DeleteOperation;
import de.sonallux.json.patching.PatchException;
import de.sonallux.json.patching.PutOperation;
import de.sonallux.json.patching.RenameOperation;
import de.sonallux.json.patching.SetOperation;
import de.sonallux.json.patching.TestOperation;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="op", include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(name="add", value=AddOperation.class), @JsonSubTypes.Type(name="set", value=SetOperation.class), @JsonSubTypes.Type(name="delete", value=DeleteOperation.class), @JsonSubTypes.Type(name="put", value=PutOperation.class), @JsonSubTypes.Type(name="rename", value=RenameOperation.class), @JsonSubTypes.Type(name="test", value=TestOperation.class)})
public abstract class PatchOperation {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @JsonIgnore
    protected static final Configuration JSON_PATH_CONFIG = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider(OBJECT_MAPPER)).mappingProvider((MappingProvider)new JacksonMappingProvider(OBJECT_MAPPER)).build();
    @JsonTypeId
    protected final String op;
    @JsonProperty
    protected final String path;

    public abstract JsonNode apply(JsonNode var1) throws PatchException;

    protected PatchException wrapException(JsonPathException e) {
        String message = e.getMessage();
        if (message == null) {
            message = ((Object)((Object)e)).getClass().getSimpleName();
        }
        return new PatchException(message, e);
    }

    protected PatchOperation(String op, String path) {
        this.op = op;
        this.path = path;
    }

    public String getOp() {
        return this.op;
    }

    public String getPath() {
        return this.path;
    }
}

