/*
 * Decompiled with CFR 0.152.
 */
package de.solugo.gradle.test.core;

import de.solugo.gradle.test.core.Directory;
import de.solugo.gradle.test.core.GradleTest;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lde/solugo/gradle/test/core/Directory;", "Ljava/lang/AutoCloseable;", "path", "Ljava/nio/file/Path;", "deleteOnFinish", "", "(Ljava/nio/file/Path;Z)V", "getDeleteOnFinish", "()Z", "getPath", "()Ljava/nio/file/Path;", "close", "", "Helper", "gradle-test-core"})
public final class Directory
implements AutoCloseable {
    @NotNull
    public static final Helper Helper = new Helper(null);
    @NotNull
    private final Path path;
    private final boolean deleteOnFinish;

    public Directory(@NotNull Path path2, boolean deleteOnFinish) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.path = path2;
        this.deleteOnFinish = deleteOnFinish;
    }

    public /* synthetic */ Directory(Path path2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(path2, bl);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public final boolean getDeleteOnFinish() {
        return this.deleteOnFinish;
    }

    @Override
    public void close() {
        if (this.deleteOnFinish) {
            Files.walk(this.path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(arg_0 -> Directory.close$lambda$0(close.1.INSTANCE, arg_0));
        }
    }

    private static final void close$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0019\b\u0002\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tJ#\u0010\n\u001a\u00020\b*\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u00020\b*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u000eJ5\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0019\b\u0002\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tJ5\u0010\u0011\u001a\n \u0015*\u0004\u0018\u00010\u000b0\u000b*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0019\b\u0002\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tJ%\u0010\u0016\u001a\u00020\u0002*\u00020\u00052\u0019\b\u0002\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\t\u00a8\u0006\u0017"}, d2={"Lde/solugo/gradle/test/core/Directory$Helper;", "Lde/solugo/gradle/test/core/GradleTest$Key;", "Lde/solugo/gradle/test/core/Directory;", "()V", "directory", "Lde/solugo/gradle/test/core/GradleTest;", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "extractDirectoryFromClasspath", "Ljava/nio/file/Path;", "paths", "", "", "(Ljava/nio/file/Path;[Ljava/lang/String;)V", "extractFileFromClasspath", "path", "name", "file", "Ljava/io/File;", "kotlin.jvm.PlatformType", "withTemporaryDirectory", "gradle-test-core"})
    @SourceDebugExtension(value={"SMAP\nDirectory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Directory.kt\nde/solugo/gradle/test/core/Directory$Helper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n13506#2:65\n13507#2:68\n1819#3,2:66\n*S KotlinDebug\n*F\n+ 1 Directory.kt\nde/solugo/gradle/test/core/Directory$Helper\n*L\n50#1:65\n50#1:68\n51#1:66,2\n*E\n"})
    public static final class Helper
    extends GradleTest.Key<Directory> {
        private Helper() {
        }

        @NotNull
        public final Directory directory(@NotNull GradleTest $this$directory, @NotNull Function1<? super Directory, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Object t = $this$directory.get(Helper);
            block.invoke(t);
            return (Directory)t;
        }

        public static /* synthetic */ Directory directory$default(Helper helper, GradleTest gradleTest, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = directory.1.INSTANCE;
            }
            return helper.directory(gradleTest, (Function1<? super Directory, Unit>)function1);
        }

        @NotNull
        public final Directory withTemporaryDirectory(@NotNull GradleTest $this$withTemporaryDirectory, @NotNull Function1<? super Directory, Unit> block) {
            Directory directory2;
            Intrinsics.checkNotNullParameter((Object)$this$withTemporaryDirectory, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Path path2 = Files.createTempDirectory("gradleProject", new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempDirectory(\"gradleProject\")");
            Directory $this$withTemporaryDirectory_u24lambda_u240 = directory2 = new Directory(path2, true);
            boolean bl = false;
            $this$withTemporaryDirectory.set(Helper, $this$withTemporaryDirectory_u24lambda_u240);
            block.invoke((Object)$this$withTemporaryDirectory_u24lambda_u240);
            return directory2;
        }

        public static /* synthetic */ Directory withTemporaryDirectory$default(Helper helper, GradleTest gradleTest, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = withTemporaryDirectory.1.INSTANCE;
            }
            return helper.withTemporaryDirectory(gradleTest, (Function1<? super Directory, Unit>)function1);
        }

        public final Path path(@NotNull GradleTest $this$path, @NotNull String path2, @NotNull Function1<? super Path, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Path path3 = ((Directory)$this$path.get(Helper)).getPath().resolve(path2);
            block.invoke((Object)path3);
            return path3;
        }

        public static /* synthetic */ Path path$default(Helper helper, GradleTest gradleTest, String string, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = path.1.INSTANCE;
            }
            return helper.path(gradleTest, string, (Function1<? super Path, Unit>)function1);
        }

        public final File file(@NotNull GradleTest $this$file, @NotNull String path2, @NotNull Function1<? super File, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            File file2 = ((Directory)$this$file.get(Helper)).getPath().resolve(path2).toFile();
            block.invoke((Object)file2);
            return file2;
        }

        public static /* synthetic */ File file$default(Helper helper, GradleTest gradleTest, String string, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = file.1.INSTANCE;
            }
            return helper.file(gradleTest, string, (Function1<? super File, Unit>)function1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void extractFileFromClasspath(@NotNull Path $this$extractFileFromClasspath, @NotNull String path2, @NotNull String name) {
            Path path3;
            Intrinsics.checkNotNullParameter((Object)$this$extractFileFromClasspath, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Path target = path3 = $this$extractFileFromClasspath.resolve(name);
            boolean bl = false;
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Closeable closeable = Files.newOutputStream(target, new OpenOption[0]);
            Throwable throwable = null;
            try {
                Closeable closeable2;
                OutputStream outputStream = (OutputStream)closeable;
                boolean bl2 = false;
                InputStream inputStream = closeable2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(path2);
                if (inputStream == null) {
                    boolean bl3 = false;
                    String string = "Could not find resource " + path2;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                closeable2 = inputStream;
                Throwable throwable2 = null;
                try {
                    Closeable inputStream2 = closeable2;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
                    ByteStreamsKt.copyTo$default((InputStream)inputStream2, (OutputStream)outputStream, (int)0, (int)2, null);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public static /* synthetic */ void extractFileFromClasspath$default(Helper helper, Path path2, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null);
            }
            helper.extractFileFromClasspath(path2, string, string2);
        }

        public final void extractDirectoryFromClasspath(@NotNull Path $this$extractDirectoryFromClasspath, String ... paths) {
            Intrinsics.checkNotNullParameter((Object)$this$extractDirectoryFromClasspath, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
            String[] $this$forEach$iv = paths;
            boolean $i$f$forEach = false;
            String[] stringArray = $this$forEach$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String path2 = element$iv = stringArray[i];
                boolean bl = false;
                String[] stringArray2 = new String[]{path2};
                ResourceList resourceList = new ClassGraph().acceptPaths(stringArray2).scan().getAllResources();
                Intrinsics.checkNotNullExpressionValue((Object)resourceList, (String)"ClassGraph().acceptPaths(path).scan().allResources");
                Iterable $this$forEach$iv2 = (Iterable)resourceList;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Resource resource = (Resource)element$iv2;
                    boolean bl2 = false;
                    String string = resource.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resource.path");
                    String string2 = resource.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resource.path");
                    Helper.extractFileFromClasspath($this$extractDirectoryFromClasspath, string, StringsKt.removePrefix((String)StringsKt.removePrefix((String)string2, (CharSequence)path2), (CharSequence)"/"));
                }
            }
        }

        public /* synthetic */ Helper(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

