/*
 * Decompiled with CFR 0.152.
 */
package de.solugo.gradle.test.core;

import de.solugo.gradle.test.core.Directory;
import de.solugo.gradle.test.core.GradleTest;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lde/solugo/gradle/test/core/Directory;", "Ljava/lang/AutoCloseable;", "path", "Ljava/nio/file/Path;", "deleteOnFinish", "", "(Ljava/nio/file/Path;Z)V", "getDeleteOnFinish", "()Z", "getPath", "()Ljava/nio/file/Path;", "close", "", "Helper", "gradle-test-core"})
public final class Directory
implements AutoCloseable {
    @NotNull
    public static final Helper Helper = new Helper(null);
    @NotNull
    private final Path path;
    private final boolean deleteOnFinish;

    public Directory(@NotNull Path path2, boolean deleteOnFinish) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.path = path2;
        this.deleteOnFinish = deleteOnFinish;
    }

    public /* synthetic */ Directory(Path path2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(path2, bl);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public final boolean getDeleteOnFinish() {
        return this.deleteOnFinish;
    }

    @Override
    public void close() {
        if (this.deleteOnFinish) {
            Files.walk(this.path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(Files::delete);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0019\b\u0002\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tJ#\u0010\n\u001a\u00020\b*\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u00020\b*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u000eJ5\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0019\b\u0002\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tJ5\u0010\u0011\u001a\n \u0015*\u0004\u0018\u00010\u000b0\u000b*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0019\b\u0002\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tJ%\u0010\u0016\u001a\u00020\u0002*\u00020\u00052\u0019\b\u0002\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\t\u00a8\u0006\u0017"}, d2={"Lde/solugo/gradle/test/core/Directory$Helper;", "Lde/solugo/gradle/test/core/GradleTest$Key;", "Lde/solugo/gradle/test/core/Directory;", "()V", "directory", "Lde/solugo/gradle/test/core/GradleTest;", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "extractDirectoryFromClasspath", "Ljava/nio/file/Path;", "paths", "", "", "(Ljava/nio/file/Path;[Ljava/lang/String;)V", "extractFileFromClasspath", "path", "name", "file", "Ljava/io/File;", "kotlin.jvm.PlatformType", "withTemporaryDirectory", "gradle-test-core"})
    public static final class Helper
    extends GradleTest.Key<Directory> {
        private Helper() {
        }

        @NotNull
        public final Directory directory(@NotNull GradleTest $this$directory, @NotNull Function1<? super Directory, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Object t = $this$directory.get(Helper);
            boolean bl = false;
            boolean bl2 = false;
            block.invoke(t);
            return (Directory)t;
        }

        public static /* synthetic */ Directory directory$default(Helper helper, GradleTest gradleTest, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = directory.1.INSTANCE;
            }
            return helper.directory(gradleTest, (Function1<? super Directory, Unit>)function1);
        }

        @NotNull
        public final Directory withTemporaryDirectory(@NotNull GradleTest $this$withTemporaryDirectory, @NotNull Function1<? super Directory, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$withTemporaryDirectory, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Object object = Files.createTempDirectory("gradleProject", new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createTempDirectory(\"gradleProject\")");
            object = new Directory((Path)object, true);
            boolean bl = false;
            boolean bl2 = false;
            Object $this$withTemporaryDirectory_u24lambda_u2d0 = object;
            boolean bl3 = false;
            $this$withTemporaryDirectory.set(Helper, $this$withTemporaryDirectory_u24lambda_u2d0);
            block.invoke($this$withTemporaryDirectory_u24lambda_u2d0);
            return object;
        }

        public static /* synthetic */ Directory withTemporaryDirectory$default(Helper helper, GradleTest gradleTest, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = withTemporaryDirectory.1.INSTANCE;
            }
            return helper.withTemporaryDirectory(gradleTest, (Function1<? super Directory, Unit>)function1);
        }

        public final Path path(@NotNull GradleTest $this$path, @NotNull String path2, @NotNull Function1<? super Path, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Path path3 = ((Directory)$this$path.get(Helper)).getPath().resolve(path2);
            boolean bl = false;
            boolean bl2 = false;
            block.invoke((Object)path3);
            return path3;
        }

        public static /* synthetic */ Path path$default(Helper helper, GradleTest gradleTest, String string, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = path.1.INSTANCE;
            }
            return helper.path(gradleTest, string, (Function1<? super Path, Unit>)function1);
        }

        public final File file(@NotNull GradleTest $this$file, @NotNull String path2, @NotNull Function1<? super File, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            File file2 = ((Directory)$this$file.get(Helper)).getPath().resolve(path2).toFile();
            boolean bl = false;
            boolean bl2 = false;
            block.invoke((Object)file2);
            return file2;
        }

        public static /* synthetic */ File file$default(Helper helper, GradleTest gradleTest, String string, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = file.1.INSTANCE;
            }
            return helper.file(gradleTest, string, (Function1<? super File, Unit>)function1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void extractFileFromClasspath(@NotNull Path $this$extractFileFromClasspath, @NotNull String path2, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)$this$extractFileFromClasspath, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Path path3 = $this$extractFileFromClasspath.resolve(name);
            boolean bl = false;
            boolean bl2 = false;
            Path target = path3;
            boolean bl3 = false;
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Closeable closeable = Files.newOutputStream(target, new OpenOption[0]);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                OutputStream outputStream = (OutputStream)closeable;
                boolean bl6 = false;
                Closeable closeable2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(path2);
                boolean bl7 = false;
                boolean bl8 = false;
                if (closeable2 == null) {
                    boolean bl9 = false;
                    String string = Intrinsics.stringPlus((String)"Could not find resource ", (Object)path2);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                closeable2 = closeable2;
                bl7 = false;
                bl8 = false;
                Throwable throwable2 = null;
                try {
                    Closeable inputStream = closeable2;
                    boolean bl10 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
                    ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public static /* synthetic */ void extractFileFromClasspath$default(Helper helper, Path path2, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null);
            }
            helper.extractFileFromClasspath(path2, string, string2);
        }

        public final void extractDirectoryFromClasspath(@NotNull Path $this$extractDirectoryFromClasspath, String ... paths) {
            Intrinsics.checkNotNullParameter((Object)$this$extractDirectoryFromClasspath, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
            String[] $this$forEach$iv = paths;
            boolean $i$f$forEach = false;
            String[] stringArray = $this$forEach$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String path2 = element$iv = stringArray[i];
                boolean bl = false;
                String[] stringArray2 = new String[]{path2};
                ResourceList resourceList = new ClassGraph().acceptPaths(stringArray2).scan().getAllResources();
                Intrinsics.checkNotNullExpressionValue((Object)resourceList, (String)"ClassGraph().acceptPaths(path).scan().allResources");
                Iterable $this$forEach$iv2 = (Iterable)resourceList;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Resource resource = (Resource)element$iv2;
                    boolean bl2 = false;
                    String string = resource.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resource.path");
                    String string2 = string;
                    string = resource.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resource.path");
                    Helper.extractFileFromClasspath($this$extractDirectoryFromClasspath, string2, StringsKt.removePrefix((String)StringsKt.removePrefix((String)string, (CharSequence)path2), (CharSequence)"/"));
                }
            }
        }

        public /* synthetic */ Helper(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

