/*
 * Decompiled with CFR 0.152.
 */
package de.solidblocks.infra.test.files;

import de.solidblocks.infra.test.UtilsKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/solidblocks/infra/test/files/FileBuilder;", "", "path", "Ljava/nio/file/Path;", "name", "", "start", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "content", "", "executable", "", "create", "solidblocks-test"})
@SourceDebugExtension(value={"SMAP\nFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Files.kt\nde/solidblocks/infra/test/files/FileBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class FileBuilder {
    @NotNull
    private final Path path;
    @NotNull
    private final String name;
    private final long start;
    @NotNull
    private byte[] content;
    private boolean executable;

    private FileBuilder(Path path, String name, long start) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.path = path;
        this.name = name;
        this.start = start;
        this.content = new byte[0];
    }

    public /* synthetic */ FileBuilder(Path path, String string, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        }
        this(path, string, l, null);
    }

    @NotNull
    public final FileBuilder content(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String string = content;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.content(byArray);
    }

    @NotNull
    public final FileBuilder content(@NotNull byte[] content) {
        FileBuilder fileBuilder;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        FileBuilder $this$content_u24lambda_u240 = fileBuilder = this;
        boolean bl = false;
        $this$content_u24lambda_u240.content = content;
        return fileBuilder;
    }

    @NotNull
    public final Path create() {
        Path file = this.path.resolve(this.name);
        FilesKt.writeBytes((File)new File(file.toFile().getAbsolutePath()), (byte[])this.content);
        UtilsKt.log-D2eLuhs$default(this.start, "created file '" + file.toFile().getAbsolutePath() + "' with size " + this.content.length, null, 4, null);
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(file, new LinkOption[0]);
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        Files.setPosixFilePermissions(file, permissions);
        Intrinsics.checkNotNull((Object)file);
        return file;
    }

    @NotNull
    public final FileBuilder executable() {
        FileBuilder fileBuilder;
        FileBuilder $this$executable_u24lambda_u241 = fileBuilder = this;
        boolean bl = false;
        $this$executable_u24lambda_u241.executable = true;
        return fileBuilder;
    }

    public /* synthetic */ FileBuilder(Path path, String name, long start, DefaultConstructorMarker $constructor_marker) {
        this(path, name, start);
    }
}

