/*
 * Decompiled with CFR 0.152.
 */
package de.solidblocks.infra.test.files;

import de.solidblocks.infra.test.files.DirectoryBuilder;
import de.solidblocks.infra.test.files.FileAssertionsKt;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.collections.SizeKt;
import io.kotest.matchers.equals.ShouldEqualKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0004\u001a\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0004\u001a\u0015\u0010\t\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0086\u0004\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\n\u001a\u00020\b\u001a\"\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u00060\u0006*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\bH\u0086\u0004\u00a2\u0006\u0002\u0010\u0010\u001a\u0015\u0010\u0011\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\bH\u0086\u0004\u001a\u0015\u0010\u0013\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\bH\u0086\u0004\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0014\u001a\u00020\b\u00a8\u0006\u0016"}, d2={"shouldContainNFiles", "Lde/solidblocks/infra/test/files/DirectoryBuilder;", "fileCount", "", "shouldHaveChecksum", "", "Ljava/nio/file/Path;", "checksum", "", "shouldHaveName", "name", "haveName", "Lio/kotest/matchers/Matcher;", "singleFile", "kotlin.jvm.PlatformType", "file", "(Lde/solidblocks/infra/test/files/DirectoryBuilder;Ljava/lang/String;)Ljava/nio/file/Path;", "matchSingleFile", "regex", "shouldHaveContent", "content", "haveContent", "solidblocks-test"})
@SourceDebugExtension(value={"SMAP\nFileAssertions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileAssertions.kt\nde/solidblocks/infra/test/files/FileAssertionsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,63:1\n12834#2,3:64\n*S KotlinDebug\n*F\n+ 1 FileAssertions.kt\nde/solidblocks/infra/test/files/FileAssertionsKt\n*L\n23#1:64,3\n*E\n"})
public final class FileAssertionsKt {
    @NotNull
    public static final DirectoryBuilder shouldContainNFiles(@NotNull DirectoryBuilder $this$shouldContainNFiles, int fileCount) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainNFiles, (String)"<this>");
        List<Path> list = $this$shouldContainNFiles.files();
        Intrinsics.checkNotNullExpressionValue(list, (String)"files(...)");
        SizeKt.shouldHaveSize((Collection)list, (int)fileCount);
        return $this$shouldContainNFiles;
    }

    /*
     * WARNING - void declaration
     */
    public static final void shouldHaveChecksum(@NotNull Path $this$shouldHaveChecksum, @NotNull String checksum) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveChecksum, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        byte[] byArray = Files.readAllBytes($this$shouldHaveChecksum);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        byte[] bytes = byArray;
        byte[] byArray2 = MessageDigest.getInstance("SHA-256").digest(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        byte[] byArray3 = byArray2;
        String initial$iv = "";
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv;
            void var11_10 = element$iv = $this$fold$iv[i];
            String str = accumulator$iv;
            boolean bl = false;
            String string = "%02x";
            Object[] objectArray = new Object[]{(byte)it};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            accumulator$iv = str + string2;
        }
        String digest = accumulator$iv;
        ShouldEqualKt.shouldBeEqual((Object)digest, (Object)checksum);
    }

    public static final void shouldHaveName(@NotNull Path $this$shouldHaveName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldHaveName, FileAssertionsKt.haveName(name));
    }

    @NotNull
    public static final Matcher<Path> haveName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<Path>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String actual = ((Object)value.getFileName()).toString();
                return MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)actual, (Object)this.$name), () -> haveName.1.test$lambda$0(value, this.$name, actual), () -> haveName.1.test$lambda$1(value, this.$name));
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            public <U> Matcher<U> compose(Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(Path $value, String $name, String $actual) {
                return "Path " + $value + " should have name " + $name + " but was " + $actual;
            }

            private static final String test$lambda$1(Path $value, String $name) {
                return "Path " + $value + " should not have name of " + $name;
            }
        };
    }

    public static final Path singleFile(@NotNull DirectoryBuilder $this$singleFile, @NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)$this$singleFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return $this$singleFile.getPath().resolve(file);
    }

    @NotNull
    public static final Path matchSingleFile(@NotNull DirectoryBuilder $this$matchSingleFile, @NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)$this$matchSingleFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Path path = (Path)CollectionsKt.singleOrNull($this$matchSingleFile.files(regex));
        if (path == null) {
            throw new RuntimeException("expected regex '" + regex + "' to match exactly one file, but it matched");
        }
        return path;
    }

    public static final void shouldHaveContent(@NotNull Path $this$shouldHaveContent, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveContent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ShouldKt.should((Object)$this$shouldHaveContent, FileAssertionsKt.haveContent(content));
    }

    @NotNull
    public static final Matcher<Path> haveContent(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return (Matcher)new Matcher<Path>(content){
            final /* synthetic */ String $content;
            {
                this.$content = $content;
            }

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String actual = PathsKt.readText$default((Path)value, null, (int)1, null);
                return MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)actual, (Object)this.$content), () -> haveContent.1.test$lambda$0(value, this.$content, actual), () -> haveContent.1.test$lambda$1(value, this.$content));
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            public <U> Matcher<U> compose(Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(Path $value, String $content, String $actual) {
                return "Path " + $value + " should have content '" + $content + "' but was '" + $actual + "'";
            }

            private static final String test$lambda$1(Path $value, String $content) {
                return "Path " + $value + " should not have content '" + $content + "'";
            }
        };
    }
}

