/*
 * Decompiled with CFR 0.152.
 */
package de.solidblocks.infra.test.files;

import de.solidblocks.infra.test.UtilsKt;
import de.solidblocks.infra.test.files.FileBuilder;
import de.solidblocks.infra.test.files.FilesKt;
import java.io.Closeable;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\u000b\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u0003 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u000e0\f\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J/\u0010\u0012\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u0003 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u000e0\f\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0011J\b\u0010\u001d\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u001e"}, d2={"Lde/solidblocks/infra/test/files/DirectoryBuilder;", "Ljava/io/Closeable;", "path", "Ljava/nio/file/Path;", "start", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "<init>", "(Ljava/nio/file/Path;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getPath", "()Ljava/nio/file/Path;", "J", "files", "", "kotlin.jvm.PlatformType", "", "()Ljava/util/List;", "regex", "", "directories", "copyFromDir", "", "dir", "clean", "fileFromResource", "Lde/solidblocks/infra/test/files/FileBuilder;", "resource", "fileFromPath", "createDir", "directory", "close", "solidblocks-test"})
@SourceDebugExtension(value={"SMAP\nDirectory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Directory.kt\nde/solidblocks/infra/test/files/DirectoryBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n774#2:98\n865#2,2:99\n*S KotlinDebug\n*F\n+ 1 Directory.kt\nde/solidblocks/infra/test/files/DirectoryBuilder\n*L\n36#1:98\n36#1:99,2\n*E\n"})
public final class DirectoryBuilder
implements Closeable {
    @NotNull
    private final Path path;
    private final long start;

    private DirectoryBuilder(Path path, long start) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.start = start;
        UtilsKt.log-D2eLuhs$default(this.start, "created directory '" + this.path + "'", null, 4, null);
    }

    public /* synthetic */ DirectoryBuilder(Path path, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        }
        this(path, l, null);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public final List<Path> files() {
        return Files.walk(this.path, new FileVisitOption[0]).filter(arg_0 -> DirectoryBuilder.files$lambda$1(DirectoryBuilder::files$lambda$0, arg_0)).toList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> files(@NotNull String regex) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Regex r = new Regex(regex);
        List<Path> list = this.files();
        Intrinsics.checkNotNullExpressionValue(list, (String)"files(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!r.matches((CharSequence)((Object)it.toAbsolutePath()).toString())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final List<Path> directories() {
        return Files.walk(this.path, new FileVisitOption[0]).filter(arg_0 -> DirectoryBuilder.directories$lambda$4(DirectoryBuilder::directories$lambda$3, arg_0)).toList();
    }

    public final void copyFromDir(@NotNull Path dir) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block2;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isDirectory(dir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block3;
            }
            throw new RuntimeException("path '" + this.path + "' does not exist or is not a directory");
        }
        PathsKt.copyToRecursively$default((Path)dir, (Path)this.path, null, (boolean)false, null, (int)10, null);
    }

    public final void clean() {
        UtilsKt.log-D2eLuhs$default(this.start, "deleting content of directory '" + this.path + "'", null, 4, null);
        Files.walk(this.path, new FileVisitOption[0]).filter(arg_0 -> DirectoryBuilder.clean$lambda$6(arg_0 -> DirectoryBuilder.clean$lambda$5(this, arg_0), arg_0)).forEach(arg_0 -> DirectoryBuilder.clean$lambda$8(arg_0 -> DirectoryBuilder.clean$lambda$7(this, arg_0), arg_0));
    }

    @NotNull
    public final FileBuilder fileFromResource(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        URL uRL = this.getClass().getClassLoader().getResource(resource);
        if (uRL == null) {
            throw new RuntimeException("resource file '" + resource + "' not found");
        }
        URL r = uRL;
        String string = r.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = path.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getFileName(...)");
        return FilesKt.file(this, PathsKt.getName((Path)path2)).content(TextStreamsKt.readBytes((URL)r));
    }

    @NotNull
    public final FileBuilder fileFromPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new RuntimeException("path '" + path + "' does not exist");
        }
        Path path2 = path.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getFileName(...)");
        FileBuilder fileBuilder = FilesKt.file(this, PathsKt.getName((Path)path2));
        byte[] byArray = Files.readAllBytes(path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        return fileBuilder.content(byArray);
    }

    @NotNull
    public final DirectoryBuilder createDir(@NotNull String directory) {
        DirectoryBuilder directoryBuilder;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Path path = this.path.resolve(directory);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        DirectoryBuilder $this$createDir_u24lambda_u249 = directoryBuilder = new DirectoryBuilder(path, 0L, 2, null);
        boolean bl = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$createDir_u24lambda_u249.path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories($this$createDir_u24lambda_u249.path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        }
        return directoryBuilder;
    }

    @Override
    public void close() {
        UtilsKt.log-D2eLuhs$default(this.start, "deleting directory '" + this.path + "'", null, 4, null);
        PathsKt.deleteRecursively((Path)this.path);
    }

    private static final boolean files$lambda$0(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean files$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean directories$lambda$3(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean directories$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean clean$lambda$5(DirectoryBuilder this$0, Path it) {
        if (Intrinsics.areEqual((Object)it.toAbsolutePath(), (Object)this$0.path.toAbsolutePath())) return false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return true;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
        return true;
    }

    private static final boolean clean$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit clean$lambda$7(DirectoryBuilder this$0, Path it) {
        UtilsKt.log-D2eLuhs$default(this$0.start, "deleting  '" + it + "'", null, 4, null);
        Intrinsics.checkNotNull((Object)it);
        PathsKt.deleteRecursively((Path)it);
        return Unit.INSTANCE;
    }

    private static final void clean$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public /* synthetic */ DirectoryBuilder(Path path, long start, DefaultConstructorMarker $constructor_marker) {
        this(path, start);
    }
}

