/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.vtte;

import java.util.Collections;
import java.util.Map;
import java.util.Stack;

public class VeryTrivialTemplateEngine {
    private final String rootTemplate;

    public VeryTrivialTemplateEngine(String rootTemplate) {
        if (rootTemplate == null) {
            throw new IllegalArgumentException("rootTemplate is null");
        }
        this.rootTemplate = rootTemplate;
    }

    public String render(Map<String, ?> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        Renderer r = new Renderer(0, this.rootTemplate, Collections.unmodifiableMap(properties));
        StringBuilder sb = new StringBuilder();
        r.render(sb);
        return sb.toString();
    }

    static String shortenString(String str, int offset, int start, int end) {
        int s1;
        String result = "";
        int startPos = start + offset;
        int endPos = end + offset;
        int s0 = Math.max(0, startPos - 12);
        if (s0 < 3) {
            s0 = 0;
        } else {
            result = "...";
        }
        int e0 = Math.min(startPos + 12, str.length());
        int e1 = Math.min(endPos + 12, str.length());
        if (str.length() - 3 < e1) {
            e1 = str.length();
        }
        result = (s1 = Math.max(0, endPos - 12)) < e0 + 3 || e1 - s0 < 24 ? result + str.substring(s0, startPos) + "*" + str.substring(startPos, endPos) + "*" + str.substring(endPos, e1) : result + str.substring(s0, startPos) + "*" + str.substring(startPos, e0) + "..." + str.substring(s1, endPos) + "*" + str.substring(endPos, e1);
        if (e1 != str.length()) {
            result = result + "...";
        }
        return result;
    }

    private static class StackEntry {
        private final char match;
        private final int pos;

        private StackEntry(char match, int pos) {
            this.match = match;
            this.pos = pos;
        }
    }

    private final class Renderer {
        private int templatePos = 0;
        private final String template;
        private final Map<String, ?> properties;
        private final int rootOffset;

        private Renderer(int rootOffset, String template, Map<String, ?> properties) {
            this.rootOffset = rootOffset;
            this.template = template;
            this.properties = properties;
        }

        private boolean render(StringBuilder target) {
            boolean propSubstition = false;
            block5: while (this.templatePos < this.template.length()) {
                char c = this.template.charAt(this.templatePos++);
                int endPos = -1;
                switch (c) {
                    case '\\': {
                        if (this.templatePos >= this.template.length()) continue block5;
                        target.append(this.processEscape(this.templatePos++));
                        continue block5;
                    }
                    case '[': {
                        endPos = this.findClosingPosition(this.templatePos, ']');
                        Renderer r = new Renderer(this.templatePos, this.template.substring(this.templatePos, endPos), this.properties);
                        StringBuilder sb = new StringBuilder();
                        if (r.render(sb)) {
                            propSubstition = true;
                            target.append((CharSequence)sb);
                        }
                        this.templatePos = endPos + 1;
                        continue block5;
                    }
                    case '{': {
                        endPos = this.findClosingPosition(this.templatePos, '}');
                        propSubstition |= this.substituteProperty(target, this.template.substring(this.templatePos, endPos));
                        this.templatePos = endPos + 1;
                        continue block5;
                    }
                }
                target.append(c);
            }
            return propSubstition;
        }

        private char processEscape(int pos) {
            char e = this.template.charAt(pos);
            switch (e) {
                case 'n': {
                    return '\n';
                }
                case 't': {
                    return '\t';
                }
            }
            return e;
        }

        private int findClosingPosition(int start, char match) {
            Stack<StackEntry> braceStack = new Stack<StackEntry>();
            int pos = start;
            braceStack.push(new StackEntry(match, start));
            while (pos < this.template.length()) {
                char c = this.template.charAt(pos++);
                switch (c) {
                    case '\\': {
                        ++pos;
                        break;
                    }
                    case '[': {
                        braceStack.push(new StackEntry(']', pos));
                        break;
                    }
                    case '{': {
                        braceStack.push(new StackEntry('}', pos));
                        break;
                    }
                    case ']': 
                    case '}': {
                        StackEntry entry = (StackEntry)braceStack.pop();
                        if (entry.match != c) {
                            throw new IllegalStateException(String.format("encountered unexpected '%c' (%s)", Character.valueOf(c), VeryTrivialTemplateEngine.shortenString(VeryTrivialTemplateEngine.this.rootTemplate, this.rootOffset, entry.pos - 1, pos)));
                        }
                        if (!braceStack.isEmpty()) break;
                        return pos - 1;
                    }
                }
            }
            throw new IllegalStateException(String.format("required match '%c' not found (%s)", Character.valueOf(match), VeryTrivialTemplateEngine.shortenString(VeryTrivialTemplateEngine.this.rootTemplate, this.rootOffset, start - 1, this.template.length())));
        }

        private boolean substituteProperty(StringBuilder target, String key) {
            if (key.length() == 0) {
                return false;
            }
            String defaultValue = "";
            int colonIndex = key.indexOf(58);
            if (colonIndex != -1) {
                defaultValue = key.substring(colonIndex + 1);
                key = key.substring(0, colonIndex);
            }
            if (this.properties.containsKey(key)) {
                Object value = this.properties.get(key);
                if (value != null) {
                    if (value instanceof Boolean) {
                        return (Boolean)value;
                    }
                    target.append(value.toString());
                    return true;
                }
                return false;
            }
            if (defaultValue.length() > 0) {
                target.append(defaultValue);
                return true;
            }
            return false;
        }
    }
}

