/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import de.softwareforge.testing.postgres.embedded.AutoValue_DatabaseInfo;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgres;
import java.sql.SQLException;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;

@AutoValue
public abstract class DatabaseInfo {
    public static final String JDBC_FORMAT = "jdbc:postgresql://localhost:%d/%s?user=%s";
    public static final String PG_DEFAULT_USER = "postgres";
    public static final String PG_DEFAULT_DB = "postgres";

    public abstract String dbName();

    public abstract int port();

    public abstract String user();

    public abstract ImmutableMap<String, String> properties();

    public abstract Optional<SQLException> exception();

    public static Builder builder() {
        return new AutoValue_DatabaseInfo.Builder().dbName("postgres").user("postgres");
    }

    public static DatabaseInfo forException(SQLException e) {
        return DatabaseInfo.builder().exception(e).port(-1).build();
    }

    public String asJdbcUrl() {
        Preconditions.checkState((boolean)this.exception().isEmpty(), (String)"DatabaseInfo contains SQLException: %s", this.exception());
        String additionalParameters = this.properties().entrySet().stream().map(e -> String.format("&%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining());
        return String.format(JDBC_FORMAT, this.port(), this.dbName(), this.user()) + additionalParameters;
    }

    public DataSource asDataSource() throws SQLException {
        Preconditions.checkState((boolean)this.exception().isEmpty(), (String)"DatabaseInfo contains SQLException: %s", this.exception());
        return EmbeddedPostgres.createDataSource(this.user(), this.dbName(), this.port(), this.properties());
    }

    public String asString() {
        if (this.exception().isPresent()) {
            return "<no connection>: " + this.exception().toString();
        }
        return this.asJdbcUrl();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder dbName(String var1);

        public abstract Builder port(int var1);

        public abstract Builder user(String var1);

        abstract Builder exception(SQLException var1);

        abstract ImmutableMap.Builder<String, String> propertiesBuilder();

        public final Builder addProperty(String key, String value) {
            this.propertiesBuilder().put((Object)key, (Object)value);
            return this;
        }

        public abstract Builder properties(ImmutableMap<String, String> var1);

        public abstract DatabaseInfo build();
    }
}

