/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.collect.ImmutableMap;
import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import java.sql.SQLException;
import java.util.Optional;

final class AutoValue_DatabaseInfo
extends DatabaseInfo {
    private final String dbName;
    private final int port;
    private final String user;
    private final ImmutableMap<String, String> properties;
    private final Optional<SQLException> exception;

    private AutoValue_DatabaseInfo(String dbName, int port, String user, ImmutableMap<String, String> properties, Optional<SQLException> exception) {
        this.dbName = dbName;
        this.port = port;
        this.user = user;
        this.properties = properties;
        this.exception = exception;
    }

    @Override
    public String dbName() {
        return this.dbName;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String user() {
        return this.user;
    }

    @Override
    public ImmutableMap<String, String> properties() {
        return this.properties;
    }

    @Override
    public Optional<SQLException> exception() {
        return this.exception;
    }

    public String toString() {
        return "DatabaseInfo{dbName=" + this.dbName + ", port=" + this.port + ", user=" + this.user + ", properties=" + this.properties + ", exception=" + this.exception + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DatabaseInfo) {
            DatabaseInfo that = (DatabaseInfo)o;
            return this.dbName.equals(that.dbName()) && this.port == that.port() && this.user.equals(that.user()) && this.properties.equals(that.properties()) && this.exception.equals(that.exception());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.dbName.hashCode();
        h$ *= 1000003;
        h$ ^= this.port;
        h$ *= 1000003;
        h$ ^= this.user.hashCode();
        h$ *= 1000003;
        h$ ^= this.properties.hashCode();
        h$ *= 1000003;
        return h$ ^= this.exception.hashCode();
    }

    static final class Builder
    extends DatabaseInfo.Builder {
        private String dbName;
        private Integer port;
        private String user;
        private ImmutableMap.Builder<String, String> propertiesBuilder$;
        private ImmutableMap<String, String> properties;
        private Optional<SQLException> exception = Optional.empty();

        Builder() {
        }

        @Override
        public DatabaseInfo.Builder dbName(String dbName) {
            if (dbName == null) {
                throw new NullPointerException("Null dbName");
            }
            this.dbName = dbName;
            return this;
        }

        @Override
        public DatabaseInfo.Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public DatabaseInfo.Builder user(String user) {
            if (user == null) {
                throw new NullPointerException("Null user");
            }
            this.user = user;
            return this;
        }

        @Override
        public DatabaseInfo.Builder properties(ImmutableMap<String, String> properties) {
            if (properties == null) {
                throw new NullPointerException("Null properties");
            }
            if (this.propertiesBuilder$ != null) {
                throw new IllegalStateException("Cannot set properties after calling propertiesBuilder()");
            }
            this.properties = properties;
            return this;
        }

        @Override
        ImmutableMap.Builder<String, String> propertiesBuilder() {
            if (this.propertiesBuilder$ == null) {
                if (this.properties == null) {
                    this.propertiesBuilder$ = ImmutableMap.builder();
                } else {
                    this.propertiesBuilder$ = ImmutableMap.builder();
                    this.propertiesBuilder$.putAll(this.properties);
                    this.properties = null;
                }
            }
            return this.propertiesBuilder$;
        }

        @Override
        DatabaseInfo.Builder exception(SQLException exception) {
            this.exception = Optional.of(exception);
            return this;
        }

        @Override
        public DatabaseInfo build() {
            if (this.propertiesBuilder$ != null) {
                this.properties = this.propertiesBuilder$.build();
            } else if (this.properties == null) {
                this.properties = ImmutableMap.of();
            }
            Object missing = "";
            if (this.dbName == null) {
                missing = (String)missing + " dbName";
            }
            if (this.port == null) {
                missing = (String)missing + " port";
            }
            if (this.user == null) {
                missing = (String)missing + " user";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_DatabaseInfo(this.dbName, this.port, this.user, this.properties, this.exception);
        }
    }
}

