/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.junit5;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.Junit5ClassMemberTest;
import de.softwareforge.testing.postgres.junit5.SingleDatabaseBuilder;
import java.sql.SQLException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class IsolationTest {
    @RegisterExtension
    public EmbeddedPgExtension pg1 = (EmbeddedPgExtension)SingleDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public EmbeddedPgExtension pg2 = (EmbeddedPgExtension)SingleDatabaseBuilder.instanceWithDefaults().build();

    @Test
    public void testDoubleTable() throws Exception {
        Assertions.assertEquals((int)0, (int)Junit5ClassMemberTest.createTable(this.pg1, "table1"));
        SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> Junit5ClassMemberTest.createTable(this.pg1, "table1"));
        Assertions.assertEquals((Object)"42P07", (Object)e.getSQLState());
        Assertions.assertTrue((boolean)Junit5ClassMemberTest.existsTable(this.pg1, "table1"));
    }

    @Test
    public void testSameTable() throws Exception {
        Assertions.assertEquals((int)0, (int)Junit5ClassMemberTest.createTable(this.pg1, "table1"));
        Assertions.assertEquals((int)0, (int)Junit5ClassMemberTest.createTable(this.pg2, "table1"));
        Assertions.assertTrue((boolean)Junit5ClassMemberTest.existsTable(this.pg1, "table1"));
        Assertions.assertTrue((boolean)Junit5ClassMemberTest.existsTable(this.pg2, "table1"));
    }

    @Test
    public void testDifferentTable() throws Exception {
        Assertions.assertEquals((int)0, (int)Junit5ClassMemberTest.createTable(this.pg1, "table1"));
        Assertions.assertEquals((int)0, (int)Junit5ClassMemberTest.createTable(this.pg2, "table2"));
        Assertions.assertTrue((boolean)Junit5ClassMemberTest.existsTable(this.pg1, "table1"));
        Assertions.assertFalse((boolean)Junit5ClassMemberTest.existsTable(this.pg1, "table2"));
        Assertions.assertTrue((boolean)Junit5ClassMemberTest.existsTable(this.pg2, "table2"));
        Assertions.assertFalse((boolean)Junit5ClassMemberTest.existsTable(this.pg2, "table1"));
    }
}

