/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import de.softwareforge.testing.postgres.embedded.EmbeddedPostgres;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class LocalDirectoryPostgresTest {
    private static final File USR_LOCAL = new File("/usr/local");
    private static final File USR_LOCAL_BIN_POSTGRES = new File(USR_LOCAL, "/bin/postgres");

    @Test
    public void testEmbeddedPg() throws Exception {
        Assumptions.assumeTrue((boolean)USR_LOCAL_BIN_POSTGRES.exists(), (String)"Skipping test, PostgreSQL binary not found in /usr/local/bin");
        try (EmbeddedPostgres pg = EmbeddedPostgres.builderWithDefaults().setPostgresBinaryDirectory(USR_LOCAL).build();
             Connection c = pg.createDefaultDataSource().getConnection();
             Statement s = c.createStatement();
             ResultSet rs = s.executeQuery("SELECT 1");){
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertEquals((int)1, (int)rs.getInt(1));
            Assertions.assertFalse((boolean)rs.next());
        }
    }
}

