/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import de.softwareforge.testing.postgres.embedded.EmbeddedPostgres;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.postgresql.PGProperty;
import org.postgresql.ds.PGSimpleDataSource;

public class EmbeddedPostgresTest {
    @TempDir
    public Path tempDir;

    @Test
    public void testEmbeddedPg() throws Exception {
        try (EmbeddedPostgres pg = EmbeddedPostgres.defaultInstance();
             Connection c = pg.createDefaultDataSource().getConnection();
             Statement s = c.createStatement();
             ResultSet rs = s.executeQuery("SELECT 1");){
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertEquals((int)1, (int)rs.getInt(1));
            Assertions.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testEmbeddedPgCreationWithNestedDataDirectory() throws Exception {
        Path dataPath = Files.createDirectories(this.tempDir.resolve("data-dir-parent").resolve("data-dir"), new FileAttribute[0]);
        try (EmbeddedPostgres pg = EmbeddedPostgres.builderWithDefaults().setDataDirectory(dataPath).build();){
            Assertions.assertEquals((Object)dataPath, (Object)pg.getDataDirectory().toPath());
        }
    }

    @Test
    public void testDatasources() throws Exception {
        try (EmbeddedPostgres pg = EmbeddedPostgres.builderWithDefaults().addConnectionProperty(PGProperty.CONNECT_TIMEOUT.getName(), "20").build();){
            DataSource ds1 = pg.createDefaultDataSource();
            DataSource ds2 = pg.createDefaultDatabaseInfo().asDataSource();
            Assertions.assertSame(ds1.getClass(), ds2.getClass());
            PGSimpleDataSource pds1 = (PGSimpleDataSource)ds1;
            PGSimpleDataSource pds2 = (PGSimpleDataSource)ds2;
            Assertions.assertArrayEquals((Object[])pds1.getServerNames(), (Object[])pds2.getServerNames());
            Assertions.assertArrayEquals((int[])pds1.getPortNumbers(), (int[])pds2.getPortNumbers());
            Assertions.assertEquals((Object)pds1.getUser(), (Object)pds2.getUser());
            Assertions.assertEquals((int)pds1.getConnectTimeout(), (int)pds2.getConnectTimeout());
            Assertions.assertEquals((int)20, (int)pds1.getConnectTimeout());
        }
    }

    @Test
    public void testValidLocaleSettingsPassthrough() throws IOException {
        String locale = "";
        String lcMessages = "";
        EmbeddedPostgres.Builder builder = EmbeddedPostgres.builderWithDefaults();
        if (SystemUtils.IS_OS_WINDOWS) {
            locale = "de-de";
            lcMessages = "de-de";
        } else if (SystemUtils.IS_OS_MAC) {
            locale = "de_DE";
            lcMessages = "de_DE";
        } else if (SystemUtils.IS_OS_LINUX) {
            locale = "de_DE.utf8";
            lcMessages = "de_DE.utf8";
        } else {
            Assertions.fail((String)"System not detected!");
        }
        builder.addLocaleConfiguration("locale", locale).addLocaleConfiguration("lc-messages", lcMessages);
        try (EmbeddedPostgres pg = builder.build();){
            Map localeConfig = pg.getLocaleConfiguration();
            Assertions.assertEquals((Object)locale, localeConfig.get("locale"));
            Assertions.assertEquals((Object)lcMessages, localeConfig.get("lc-messages"));
        }
    }
}

