/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import java.sql.SQLException;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DatabaseInfoTest {
    @Test
    public void testMinimal() {
        DatabaseInfo databaseInfo = DatabaseInfo.builder().port(12345).build();
        Assertions.assertEquals((Object)"postgres", (Object)databaseInfo.user());
        Assertions.assertEquals((Object)"postgres", (Object)databaseInfo.dbName());
        Assertions.assertEquals((int)12345, (int)databaseInfo.port());
        Assertions.assertTrue((boolean)databaseInfo.properties().isEmpty());
        Assertions.assertTrue((boolean)databaseInfo.exception().isEmpty());
    }

    @Test
    public void testFull() {
        String dbName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ROOT);
        String user = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ROOT);
        int port = ThreadLocalRandom.current().nextInt(65536);
        String propertyName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ROOT);
        String propertyValue = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ROOT);
        DatabaseInfo databaseInfo = DatabaseInfo.builder().dbName(dbName).user(user).port(port).addProperty(propertyName, propertyValue).build();
        Assertions.assertEquals((Object)user, (Object)databaseInfo.user());
        Assertions.assertEquals((Object)dbName, (Object)databaseInfo.dbName());
        Assertions.assertEquals((int)port, (int)databaseInfo.port());
        Assertions.assertEquals((int)1, (int)databaseInfo.properties().size());
        Assertions.assertEquals((Object)propertyValue, (Object)databaseInfo.properties().get((Object)propertyName));
        Assertions.assertTrue((boolean)databaseInfo.exception().isEmpty());
    }

    @Test
    public void testException() {
        DatabaseInfo databaseInfo = DatabaseInfo.forException((SQLException)new SQLException());
        Assertions.assertTrue((boolean)databaseInfo.exception().isPresent());
        Assertions.assertEquals(SQLException.class, ((SQLException)databaseInfo.exception().get()).getClass());
    }
}

