/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import de.softwareforge.testing.postgres.embedded.DatabasePreparer;
import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.SingleDatabaseBuilder;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.postgresql.ds.common.BaseDataSource;

public class ConnectConfigTest {
    private final CapturingDatabasePreparer preparer = new CapturingDatabasePreparer();
    @RegisterExtension
    public EmbeddedPgExtension db = (EmbeddedPgExtension)SingleDatabaseBuilder.preparedInstanceWithDefaults((DatabasePreparer)this.preparer).withCustomizer(builder -> builder.addConnectionProperty("connectTimeout", "20")).build();

    @Test
    public void test() throws SQLException {
        DatabaseInfo databaseInfo = this.db.createDatabaseInfo();
        ImmutableMap properties = databaseInfo.properties();
        Assertions.assertEquals((int)1, (int)properties.size());
        Assertions.assertEquals((Object)"20", properties.get("connectTimeout"));
        BaseDataSource testDatabase = (BaseDataSource)this.db.createDataSource();
        Assertions.assertEquals((Object)"20", (Object)testDatabase.getProperty("connectTimeout"));
        BaseDataSource preparerDataSource = (BaseDataSource)this.preparer.getDataSource();
        Assertions.assertEquals((Object)"20", (Object)preparerDataSource.getProperty("connectTimeout"));
    }

    private class CapturingDatabasePreparer
    implements DatabasePreparer {
        private DataSource dataSource;

        private CapturingDatabasePreparer() {
        }

        public void prepare(DataSource dataSource) {
            Preconditions.checkState((this.dataSource == null ? 1 : 0) != 0, (Object)"database preparer has been called multiple times");
            this.dataSource = dataSource;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

