package de.softwareforge.testing.postgres.embedded;

import com.google.common.collect.ImmutableMap;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_DatabaseInfo extends DatabaseInfo {

  private final String dbName;

  private final int port;

  private final String user;

  private final ImmutableMap<String, String> properties;

  private final Optional<SQLException> exception;

  private AutoValue_DatabaseInfo(
      String dbName,
      int port,
      String user,
      ImmutableMap<String, String> properties,
      Optional<SQLException> exception) {
    this.dbName = dbName;
    this.port = port;
    this.user = user;
    this.properties = properties;
    this.exception = exception;
  }

  @Override
  public String dbName() {
    return dbName;
  }

  @Override
  public int port() {
    return port;
  }

  @Override
  public String user() {
    return user;
  }

  @Override
  public ImmutableMap<String, String> properties() {
    return properties;
  }

  @Override
  public Optional<SQLException> exception() {
    return exception;
  }

  @Override
  public String toString() {
    return "DatabaseInfo{"
        + "dbName=" + dbName + ", "
        + "port=" + port + ", "
        + "user=" + user + ", "
        + "properties=" + properties + ", "
        + "exception=" + exception
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DatabaseInfo) {
      DatabaseInfo that = (DatabaseInfo) o;
      return this.dbName.equals(that.dbName())
          && this.port == that.port()
          && this.user.equals(that.user())
          && this.properties.equals(that.properties())
          && this.exception.equals(that.exception());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= dbName.hashCode();
    h$ *= 1000003;
    h$ ^= port;
    h$ *= 1000003;
    h$ ^= user.hashCode();
    h$ *= 1000003;
    h$ ^= properties.hashCode();
    h$ *= 1000003;
    h$ ^= exception.hashCode();
    return h$;
  }

  static final class Builder extends DatabaseInfo.Builder {
    private String dbName;
    private Integer port;
    private String user;
    private ImmutableMap.Builder<String, String> propertiesBuilder$;
    private ImmutableMap<String, String> properties;
    private Optional<SQLException> exception = Optional.empty();
    Builder() {
    }
    @Override
    public DatabaseInfo.Builder dbName(String dbName) {
      if (dbName == null) {
        throw new NullPointerException("Null dbName");
      }
      this.dbName = dbName;
      return this;
    }
    @Override
    public DatabaseInfo.Builder port(int port) {
      this.port = port;
      return this;
    }
    @Override
    public DatabaseInfo.Builder user(String user) {
      if (user == null) {
        throw new NullPointerException("Null user");
      }
      this.user = user;
      return this;
    }
    @Override
    public DatabaseInfo.Builder properties(ImmutableMap<String, String> properties) {
      if (properties == null) {
        throw new NullPointerException("Null properties");
      }
      if (propertiesBuilder$ != null) {
        throw new IllegalStateException("Cannot set properties after calling propertiesBuilder()");
      }
      this.properties = properties;
      return this;
    }
    @Override
    ImmutableMap.Builder<String, String> propertiesBuilder() {
      if (propertiesBuilder$ == null) {
        if (properties == null) {
          propertiesBuilder$ = ImmutableMap.builder();
        } else {
          propertiesBuilder$ = ImmutableMap.builder();
          propertiesBuilder$.putAll(properties);
          properties = null;
        }
      }
      return propertiesBuilder$;
    }
    @Override
    DatabaseInfo.Builder exception(SQLException exception) {
      this.exception = Optional.of(exception);
      return this;
    }
    @Override
    public DatabaseInfo build() {
      if (propertiesBuilder$ != null) {
        this.properties = propertiesBuilder$.build();
      } else if (this.properties == null) {
        this.properties = ImmutableMap.of();
      }
      String missing = "";
      if (this.dbName == null) {
        missing += " dbName";
      }
      if (this.port == null) {
        missing += " port";
      }
      if (this.user == null) {
        missing += " user";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DatabaseInfo(
          this.dbName,
          this.port,
          this.user,
          this.properties,
          this.exception);
    }
  }

}
