/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.maven;

import java.io.File;
import org.apache.thrift.maven.Thrift;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestThrift {
    private File testRootDir;
    private File idlDir;
    private File genJavaDir;
    private Thrift.Builder builder;

    @Before
    public void setup() throws Exception {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.testRootDir = new File(tmpDir, "thrift-test");
        if (this.testRootDir.exists()) {
            FileUtils.cleanDirectory((File)this.testRootDir);
        } else {
            Assert.assertTrue((String)("Failed to create output directory for test: " + this.testRootDir.getPath()), (boolean)this.testRootDir.mkdir());
        }
        File testResourceDir = new File("src/test/resources");
        Assert.assertTrue((String)"Unable to find test resources", (boolean)this.testRootDir.exists());
        this.idlDir = new File(testResourceDir, "idl");
        this.genJavaDir = new File(this.testRootDir, "gen-java");
        this.builder = new Thrift.Builder("thrift", this.testRootDir);
        this.builder.setGenerator("java").addThriftPathElement(this.idlDir);
    }

    @Test
    public void testThriftCompile() throws Exception {
        this.executeThriftCompile();
    }

    @Test
    public void testThriftCompileWithGeneratorOption() throws Exception {
        this.builder.setGenerator("java:private-members,hashcode");
        this.executeThriftCompile();
    }

    private void executeThriftCompile() throws CommandLineException {
        File thriftFile = new File(this.idlDir, "shared.thrift");
        this.builder.addThriftFile(thriftFile);
        Thrift thrift = this.builder.build();
        Assert.assertTrue((String)"File not found: shared.thrift", (boolean)thriftFile.exists());
        Assert.assertFalse((String)"gen-java directory should not exist", (boolean)this.genJavaDir.exists());
        int result = thrift.compile();
        Assert.assertEquals((long)0L, (long)result);
        Assert.assertFalse((String)"gen-java directory was not removed", (boolean)this.genJavaDir.exists());
        Assert.assertTrue((String)"generated java code doesn't exist", (boolean)new File(this.testRootDir, "shared/SharedService.java").exists());
    }

    @Test
    public void testThriftMultipleFileCompile() throws Exception {
        File sharedThrift = new File(this.idlDir, "shared.thrift");
        File tutorialThrift = new File(this.idlDir, "tutorial.thrift");
        this.builder.addThriftFile(sharedThrift);
        this.builder.addThriftFile(tutorialThrift);
        Thrift thrift = this.builder.build();
        Assert.assertTrue((String)"File not found: shared.thrift", (boolean)sharedThrift.exists());
        Assert.assertFalse((String)"gen-java directory should not exist", (boolean)this.genJavaDir.exists());
        int result = thrift.compile();
        Assert.assertEquals((String)"could not execute thrift compiler", (long)0L, (long)result);
        Assert.assertFalse((String)"gen-java directory was not removed", (boolean)this.genJavaDir.exists());
        Assert.assertTrue((String)"generated java code doesn't exist", (boolean)new File(this.testRootDir, "shared/SharedService.java").exists());
        Assert.assertTrue((String)"generated java code doesn't exist", (boolean)new File(this.testRootDir, "tutorial/InvalidOperation.java").exists());
    }

    @Test
    public void testBadCompile() throws Exception {
        File thriftFile = new File(this.testRootDir, "missing.thrift");
        this.builder.addThriftPathElement(this.testRootDir);
        Assert.assertTrue((boolean)thriftFile.createNewFile());
        this.builder.addThriftFile(thriftFile);
        Assert.assertTrue((boolean)thriftFile.delete());
        Thrift thrift = this.builder.build();
        Assert.assertTrue((!thriftFile.exists() ? 1 : 0) != 0);
        Assert.assertFalse((String)"gen-java directory should not exist", (boolean)this.genJavaDir.exists());
        int result = thrift.compile();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testFileInPathPreCondition() throws Exception {
        File thriftFile = new File(this.testRootDir, "missing.thrift");
        Assert.assertTrue((boolean)thriftFile.createNewFile());
        try {
            this.builder.addThriftFile(thriftFile);
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @After
    public void cleanup() throws Exception {
        if (this.testRootDir.exists()) {
            FileUtils.cleanDirectory((File)this.testRootDir);
            Assert.assertTrue((String)("Failed to delete output directory for test: " + this.testRootDir.getPath()), (boolean)this.testRootDir.delete());
        }
    }
}

