/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.maven;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.thrift.maven.Thrift;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;

abstract class AbstractThriftMojo
extends AbstractMojo {
    private static final String THRIFT_FILE_SUFFIX = ".thrift";
    private static final String DEFAULT_INCLUDES = "**/*.thrift";
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    protected MavenProject project;
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    protected MavenProjectHelper projectHelper;
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    private String thriftExecutable;
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    private String generator;
    private File[] additionalThriftPathElements = new File[0];
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    private File temporaryThriftFileDirectory;
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    private ArtifactRepository localRepository;
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    private boolean hashDependentPaths;
    private Set<String> includes = ImmutableSet.of((Object)"**/*.thrift");
    private Set<String> excludes = ImmutableSet.of();
    private long staleMillis = 0L;
    private boolean checkStaleness = false;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    AbstractThriftMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkParameters();
        File thriftSourceRoot = this.getThriftSourceRoot();
        if (thriftSourceRoot.exists()) {
            try {
                ImmutableSet<File> thriftFiles = this.findThriftFilesInDirectory(thriftSourceRoot);
                File outputDirectory = this.getOutputDirectory();
                ImmutableSet<File> outputFiles = this.findGeneratedFilesInDirectory(this.getOutputDirectory());
                if (thriftFiles.isEmpty()) {
                    this.getLog().info((CharSequence)"No thrift files to compile.");
                }
                if (this.checkStaleness && this.lastModified(thriftFiles) + this.staleMillis < this.lastModified(outputFiles)) {
                    this.getLog().info((CharSequence)"Skipping compilation because target directory newer than sources.");
                    this.attachFiles();
                }
                ImmutableSet<File> derivedThriftPathElements = this.makeThriftPathFromJars(this.temporaryThriftFileDirectory, (Iterable<File>)this.getDependencyArtifactFiles());
                if (!outputDirectory.mkdirs()) {
                    throw new MojoExecutionException("Could not create directories");
                }
                FileUtils.cleanDirectory((File)outputDirectory);
                Thrift thrift = new Thrift.Builder(this.thriftExecutable, outputDirectory).setGenerator(this.generator).addThriftPathElement(thriftSourceRoot).addThriftPathElements((Iterable<File>)derivedThriftPathElements).addThriftPathElements(Arrays.asList(this.additionalThriftPathElements)).addThriftFiles((Iterable<File>)thriftFiles).build();
                int exitStatus = thrift.compile();
                if (exitStatus != 0) {
                    this.getLog().error((CharSequence)("thrift failed output: " + thrift.getOutput()));
                    this.getLog().error((CharSequence)("thrift failed error: " + thrift.getError()));
                    throw new MojoFailureException("thrift did not exit cleanly. Review output for more information.");
                }
                this.attachFiles();
            }
            catch (IOException e) {
                throw new MojoExecutionException("An IO error occured", (Exception)e);
            }
            catch (IllegalArgumentException e) {
                throw new MojoFailureException("thrift failed to execute because: " + e.getMessage(), (Throwable)e);
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("An error occurred while invoking thrift.", (Exception)((Object)e));
            }
        } else {
            this.getLog().info((CharSequence)String.format("%s does not exist. Review the configuration or consider disabling the plugin.", thriftSourceRoot));
        }
    }

    ImmutableSet<File> findGeneratedFilesInDirectory(File directory) throws IOException {
        if (directory == null || !directory.isDirectory()) {
            return ImmutableSet.of();
        }
        List javaFilesInDirectory = FileUtils.getFiles((File)directory, (String)"**/*.java", null);
        return ImmutableSet.copyOf((Collection)javaFilesInDirectory);
    }

    private long lastModified(ImmutableSet<File> files) {
        long result = 0L;
        for (File file : files) {
            if (file.lastModified() <= result) continue;
            result = file.lastModified();
        }
        return result;
    }

    private void checkParameters() {
        Preconditions.checkNotNull((Object)this.project, (Object)"project");
        Preconditions.checkNotNull((Object)this.projectHelper, (Object)"projectHelper");
        Preconditions.checkNotNull((Object)this.thriftExecutable, (Object)"thriftExecutable");
        Preconditions.checkNotNull((Object)this.generator, (Object)"generator");
        File thriftSourceRoot = this.getThriftSourceRoot();
        Preconditions.checkNotNull((Object)thriftSourceRoot);
        Preconditions.checkArgument((!thriftSourceRoot.isFile() ? 1 : 0) != 0, (Object)"thriftSourceRoot is a file, not a diretory");
        Preconditions.checkNotNull((Object)this.temporaryThriftFileDirectory, (Object)"temporaryThriftFileDirectory");
        Preconditions.checkState((!this.temporaryThriftFileDirectory.isFile() ? 1 : 0) != 0, (Object)"temporaryThriftFileDirectory is a file, not a directory");
        File outputDirectory = this.getOutputDirectory();
        Preconditions.checkNotNull((Object)outputDirectory);
        Preconditions.checkState((!outputDirectory.isFile() ? 1 : 0) != 0, (Object)"the outputDirectory is a file, not a directory");
    }

    protected abstract File getThriftSourceRoot();

    protected abstract List<Artifact> getDependencyArtifacts();

    protected abstract File getOutputDirectory();

    protected abstract void attachFiles();

    private ImmutableSet<File> getDependencyArtifactFiles() {
        HashSet dependencyArtifactFiles = Sets.newHashSet();
        for (Artifact artifact : this.getDependencyArtifacts()) {
            dependencyArtifactFiles.add(artifact.getFile());
        }
        return ImmutableSet.copyOf((Collection)dependencyArtifactFiles);
    }

    ImmutableSet<File> makeThriftPathFromJars(File temporaryThriftFileDirectory, Iterable<File> classpathElementFiles) throws IOException, MojoExecutionException {
        Preconditions.checkNotNull(classpathElementFiles, (Object)"classpathElementFiles");
        if (temporaryThriftFileDirectory.exists()) {
            FileUtils.cleanDirectory((File)temporaryThriftFileDirectory);
        }
        HashSet thriftDirectories = Sets.newHashSet();
        for (File classpathElementFile : classpathElementFiles) {
            File[] thriftFiles;
            if (classpathElementFile.isFile() && classpathElementFile.canRead() && !classpathElementFile.getName().endsWith(".xml")) {
                JarFile classpathJar = null;
                try {
                    classpathJar = new JarFile(classpathElementFile);
                    for (JarEntry jarEntry : Collections.list(classpathJar.entries())) {
                        String jarEntryName = jarEntry.getName();
                        if (!jarEntry.getName().endsWith(THRIFT_FILE_SUFFIX)) continue;
                        File uncompressedCopy = new File(new File(temporaryThriftFileDirectory, this.truncatePath(classpathJar.getName())), jarEntryName);
                        if (!uncompressedCopy.getParentFile().mkdirs()) {
                            throw new MojoExecutionException("Could not create folders for " + uncompressedCopy.getParent());
                        }
                        FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(classpathJar.getInputStream(jarEntry)), (File)uncompressedCopy);
                        thriftDirectories.add(uncompressedCopy.getParentFile());
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("%s was not a readable artifact", classpathElementFile));
                }
                finally {
                    if (classpathJar != null) {
                        classpathJar.close();
                    }
                    continue;
                }
            }
            if (!classpathElementFile.isDirectory() || (thriftFiles = classpathElementFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(AbstractThriftMojo.THRIFT_FILE_SUFFIX);
                }
            })).length <= 0) continue;
            thriftDirectories.add(classpathElementFile);
        }
        return ImmutableSet.copyOf((Collection)thriftDirectories);
    }

    ImmutableSet<File> findThriftFilesInDirectory(File directory) throws IOException {
        Preconditions.checkNotNull((Object)directory);
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"%s is not a directory", (Object[])new Object[]{directory});
        List thriftFilesInDirectory = FileUtils.getFiles((File)directory, (String)Joiner.on((String)",").join(this.includes), (String)Joiner.on((String)",").join(this.excludes));
        return ImmutableSet.copyOf((Collection)thriftFilesInDirectory);
    }

    ImmutableSet<File> findThriftFilesInDirectories(Iterable<File> directories) throws IOException {
        Preconditions.checkNotNull(directories);
        HashSet thriftFiles = Sets.newHashSet();
        for (File directory : directories) {
            thriftFiles.addAll(this.findThriftFilesInDirectory(directory));
        }
        return ImmutableSet.copyOf((Collection)thriftFiles);
    }

    String truncatePath(String jarPath) throws MojoExecutionException {
        int colonIndex;
        String path;
        int repositoryIndex;
        if (this.hashDependentPaths) {
            try {
                return AbstractThriftMojo.toHexString(MessageDigest.getInstance("MD5").digest(jarPath.getBytes(Charsets.UTF_8)));
            }
            catch (NoSuchAlgorithmException e) {
                throw new MojoExecutionException("Failed to expand dependent jar", (Exception)e);
            }
        }
        String repository = this.localRepository.getBasedir().replace('\\', '/');
        if (!repository.endsWith("/")) {
            repository = repository + "/";
        }
        if ((repositoryIndex = (path = jarPath.replace('\\', '/')).indexOf(repository)) != -1) {
            path = path.substring(repositoryIndex + repository.length());
        }
        if ((colonIndex = path.indexOf(58)) != -1) {
            path = path.substring(colonIndex + 2);
        }
        return path;
    }

    public static String toHexString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            hexString.append(HEX_CHARS[(b & 0xF0) >> 4]).append(HEX_CHARS[b & 0xF]);
        }
        return hexString.toString();
    }
}

